{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

<main class="main">

	{* слайдер *}
	{include file="modules/slider.tpl"}
    {* /слайдер *}

	{* Текстовый блок - описание раздела *}
    {fetch_section assign=aboutSection section=2 getContent=true}{if $aboutSection.status eq 'V'}
	<section class="flex:col pad-tb-100 bg-gradient rs-20" id="{$aboutSection.fileName}">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="both max">
					<div class="both__item">
						<div class="text-tmp color-white title-46"><h2>{$aboutSection.name nofilter}</h2></div>
					</div>
					<div class="both__item">
						<div class="text-tmp color-white">
							<div class="text-tmp color-white title-46">{$aboutSection.content|page_break:null nofilter}</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	{/if}
    {* /Текстовый блок - описание раздела *}

	{* Наши курсы *}
    {fetch_section assign=coursesSection section=3 getContent=true}{if $coursesSection.status eq 'V'}
	<section class="flex:col pad-tb-80 bg-white" id="{$coursesSection.fileName}">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="text-tmp title-46 all-center"><h2>{$coursesSection.name}</h2></div>
				<div class="grid:fr-3 max g-gap-20">

                    {fetch_articles limit=100 assign=courses image=true section=$coursesSection.sectionId typeContent="courses" fields="articleId, sectionId, orderBy, publishedOn, title, alias, url, summary, content, rating, course_length, course_price"}
                    {foreach from=$courses item=course}
					<div class="courses-card">
						<div class="courses-card__img"><img src="{$course.image.original}" alt="{$course.title}"></div>
						<div class="courses-card__info">
							<div class="text-tmp title-26"><h3>{$course.title}</h3></div>
							<ul>
								<li>
									<span>Сложность</span>
									<div class="courses-card__stars" data-stars="{$course.rating|string_format:"%d"}">
										<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M13 21.7742L19.3048 25.7642C20.4594 26.4955 21.8723 25.4145 21.5685 24.0474L19.8973 16.5443L25.4729 11.4892C26.4908 10.5672 25.9439 8.81858 24.6069 8.7073L17.269 8.05555L14.3977 0.965712C13.8812 -0.321904 12.1188 -0.321904 11.6023 0.965712L8.73096 8.03965L1.39307 8.69141C0.0561468 8.80268 -0.490777 10.5513 0.527109 11.4733L6.10269 16.5284L4.43153 24.0315C4.12769 25.3986 5.54057 26.4796 6.69519 25.7483L13 21.7742Z" />
										</svg>
										<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M13 21.7742L19.3048 25.7642C20.4594 26.4955 21.8723 25.4145 21.5685 24.0474L19.8973 16.5443L25.4729 11.4892C26.4908 10.5672 25.9439 8.81858 24.6069 8.7073L17.269 8.05555L14.3977 0.965712C13.8812 -0.321904 12.1188 -0.321904 11.6023 0.965712L8.73096 8.03965L1.39307 8.69141C0.0561468 8.80268 -0.490777 10.5513 0.527109 11.4733L6.10269 16.5284L4.43153 24.0315C4.12769 25.3986 5.54057 26.4796 6.69519 25.7483L13 21.7742Z" />
										</svg>
										<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M13 21.7742L19.3048 25.7642C20.4594 26.4955 21.8723 25.4145 21.5685 24.0474L19.8973 16.5443L25.4729 11.4892C26.4908 10.5672 25.9439 8.81858 24.6069 8.7073L17.269 8.05555L14.3977 0.965712C13.8812 -0.321904 12.1188 -0.321904 11.6023 0.965712L8.73096 8.03965L1.39307 8.69141C0.0561468 8.80268 -0.490777 10.5513 0.527109 11.4733L6.10269 16.5284L4.43153 24.0315C4.12769 25.3986 5.54057 26.4796 6.69519 25.7483L13 21.7742Z" />
										</svg>
										<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M13 21.7742L19.3048 25.7642C20.4594 26.4955 21.8723 25.4145 21.5685 24.0474L19.8973 16.5443L25.4729 11.4892C26.4908 10.5672 25.9439 8.81858 24.6069 8.7073L17.269 8.05555L14.3977 0.965712C13.8812 -0.321904 12.1188 -0.321904 11.6023 0.965712L8.73096 8.03965L1.39307 8.69141C0.0561468 8.80268 -0.490777 10.5513 0.527109 11.4733L6.10269 16.5284L4.43153 24.0315C4.12769 25.3986 5.54057 26.4796 6.69519 25.7483L13 21.7742Z" />
										</svg>
										<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M13 21.7742L19.3048 25.7642C20.4594 26.4955 21.8723 25.4145 21.5685 24.0474L19.8973 16.5443L25.4729 11.4892C26.4908 10.5672 25.9439 8.81858 24.6069 8.7073L17.269 8.05555L14.3977 0.965712C13.8812 -0.321904 12.1188 -0.321904 11.6023 0.965712L8.73096 8.03965L1.39307 8.69141C0.0561468 8.80268 -0.490777 10.5513 0.527109 11.4733L6.10269 16.5284L4.43153 24.0315C4.12769 25.3986 5.54057 26.4796 6.69519 25.7483L13 21.7742Z" />
										</svg>
									</div>
								</li>

								<li><span>Длительность</span><span>{$course.course_length}</span></li>
								{if $course.course_price > 0.00}
									<li><span>Стоимость</span><span>{$course.course_price|number_format:0:",":" "} сум</span></li>
								{/if}
							</ul>

							<button class="btn accent-2 transparent full courses-desc-btn_js" data-modal-id="coursesModal" data-name="{$course.title}">Подробнее</button>

							<div class="courses-desc d-none">
								<div class="grid:fr-1 g-gap-30">

									<div class="text-tmp title-46 title-dec-26 title-first-accent-2">
										<h4>{$course.title}</h4>
                                        {$course.summary nofilter}
									</div>
									{if !empty($course.content)}
										<div class="text-tmp title-26"><h5>Программа курса</h5></div>

                                        {bracket_regex assign=contents from=$course.content strip_tags=false}
										{if !empty($contents)}
											<div class="courses-desc__accard">
		                                        {foreach from=$contents item=item}
												<div class="courses-desc__accard-item">
													<button class="courses-desc__accard-btn courses-desc-accard-btn_js">{$item.code nofilter}</button>
													<div class="courses-desc__accard-drop courses-desc-accard-drop_js">
														<div class="courses-desc__accard-drop-inner">
															<div class="text-tmp title-26">{$item.content nofilter}</div>
														</div>
													</div>
												</div>
		                                        {/foreach}
											</div>
	                                    {/if}
									{/if}
								</div>
							</div>
						</div>
					</div>
					{/foreach}

				</div>
			</div>
		</div>
	</section>
	{/if}
    {* /Наши курсы *}

	{* Наши менторы *}
    {fetch_section assign=mentorsSection section=4}{if $mentorsSection.status eq 'V'}
	<section class="flex:col pad-tb-80" id="{$mentorsSection.fileName}">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="text-tmp title-46 all-center"><h2>{$mentorsSection.name}</h2></div>
                {fetch_articles limit=40 assign=mentors image=true section=$mentorsSection.sectionId typeContent="mentors"}
				<div class="flex-cards g-gap-20">

                    {foreach from=$mentors item=mentor}
					<div class="mentor-card" data-modal-id="mentor_{$mentor.articleId}">
						<div class="mentor-card__img"><img src="{$mentor.image.original}" alt="{$mentor.title|strip_tags}"></div>
						<div class="mentor-card__info">
							<ul>
								<li>{$mentor.title nofilter}</li>
								<li>{$mentor.alias nofilter}</li>
							</ul>
						</div>
					</div>
					{/foreach}
				</div>
			</div>
		</div>
	</section>
	{/if}
    {* Наши менторы *}

	{* Новости *}
    {fetch_section assign=newsSection section=5}{if $newsSection.status eq 'V'}
	<section class="flex:col pad-tb-80 bg-white" id="{$newsSection.fileName}">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="text-tmp title-46 all-center"><h2>{$newsSection.name}</h2></div>
				<div class="news">
					<button class="arrow-slider news-prev_js">
						<svg width="15" height="30" viewBox="0 0 15 30" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M0.476335 13.1994C0.171713 13.5508 0.000379015 14.0275 0 14.5248L0 15.4752C0.00498854 15.9714 0.175629 16.4462 0.476335 16.8006L11.6053 29.6301C11.8085 29.8668 12.0852 30 12.3739 30C12.6625 30 12.9392 29.8668 13.1425 29.6301L14.6798 27.8545C14.8834 27.624 14.9982 27.3085 14.9982 26.9792C14.9982 26.6499 14.8834 26.3344 14.6798 26.1039L5.04482 15L14.6798 3.89611C14.8847 3.66132 15 3.34171 15 3.0083C15 2.67489 14.8847 2.35528 14.6798 2.12049L13.1425 0.369877C12.9392 0.133152 12.6625 0 12.3739 0C12.0852 0 11.8085 0.133152 11.6053 0.369877L0.476335 13.1994Z" />
						</svg>
					</button>

                    {fetch_articles limit=40 assign=news image=true section=$newsSection.sectionId typeContent="news"}
					<div class="swiper news-slider_js">
						<div class="swiper-wrapper">
                            {foreach from=$news item=new}
							<div class="swiper-slide">
								<a class="news-card" href="{$SITE_URL}{$new.url}">
									<div class="news-card__img"><img src="{$new.image.original}" alt="{$new.title}"></div>
									<div class="news-card__info">
										<ul>
											<li>{$new.title}</li>
											<li>{$new.publishedOn|date_format:$config.date_format_custom}</li>
										</ul>
									</div>
								</a>
							</div>
							{/foreach}
						</div>
					</div>

					<button class="arrow-slider news-next_js">
						<svg width="15" height="30" viewBox="0 0 15 30" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M14.5237 16.8006C14.8283 16.4492 14.9996 15.9725 15 15.4752V14.5248C14.995 14.0286 14.8244 13.5538 14.5237 13.1994L3.39475 0.369877C3.19148 0.133154 2.91477 0 2.62612 0C2.33746 0 2.06076 0.133154 1.85749 0.369877L0.320225 2.1455C0.116561 2.37599 0.00179195 2.69147 0.00179195 3.02081C0.00179195 3.35015 0.116561 3.66562 0.320225 3.89611L9.95518 15L0.320225 26.1039C0.115279 26.3387 0 26.6583 0 26.9917C0 27.3251 0.115279 27.6447 0.320225 27.8795L1.85749 29.6301C2.06076 29.8668 2.33746 30 2.62612 30C2.91477 30 3.19148 29.8668 3.39475 29.6301L14.5237 16.8006Z" />
						</svg>
					</button>
				</div>
			</div>
		</div>
	</section>
	{/if}
    {* /Новости *}


	{* Контакты *}
    {fetch_section assign=contactsSection section=6}{if $contactsSection.status eq 'V'}
	<section class="flex:col pad-tb-80" id="{$contactsSection.fileName}">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="text-tmp title-46 all-center"><h2>{$contactsSection.name}</h2></div>

				<div class="contacts">

					<div class="contacts__map" id="map"></div>

					<div class="contacts__info">
						<div class="grid:fr-1 g-gap-30">
							<div class="text-tmp title-26"><h3>Контактная информация</h3></div>
							<div class="contacts__info-list-container">

								<div class="contacts__info-list">
									<div class="text-tmp title-20"><h4>Наш адрес</h4></div>
									<ul><li>{$config.address}</li></ul>
								</div>

								<div class="contacts__info-list">
									<div class="text-tmp title-20"><h4>Наш эл. адрес</h4></div>
									<ul><li><a href="mailto:{$config.email}">{$config.email}</a></li></ul>
								</div>

								<div class="contacts__info-list">
									<div class="text-tmp title-20"><h4>Наш эл. адрес</h4></div>
									<ul>
                                        {assign var=phones value=", "|explode:$config.phone}
                                        {foreach from=$phones item=phone name=phones}
										<li><a href="tel:{$phone|strip_phone}">{$phone|format_phone}</a></li>
                                        {/foreach}
									</ul>
								</div>

								<div class="contacts__info-list">
									<div class="text-tmp title-20"><h4>Мы в соц. сетях</h4></div>
									<div class="social">{include file="modules/socials.tpl"}</div>
								</div>

							</div>
						</div>


						<div class="grid:fr-1 g-gap-30">
							<div class="text-tmp title-26"><h3>Подать заявку</h3></div>

							<form class="form validation_js" action="{$GLOBAL_URL}/ajax-feedback" method="post" id="feedback">
                                {include file="form/captcha.tpl"}
								<div class="input">
									<label class="input__label" for>Ф.И.О</label>
									<input type="text" name="feedback[fullName]" data-empty="Обязательно для заполнения">
								</div>

								<div class="input">
									<label class="input__label" for>Телефон</label>
									<input class="phone_js" type="tel" name="feedback[phone]" data-empty="Обязательно для заполнения">
								</div>

                                {fetch_section assign=oznakomlenSection section=7}{if $oznakomlenSection.status eq 'V'}
								<div class="checkbox">
									<label class="checkbox__label">
										<input class="checkbox__input" type="checkbox">

										<span class="checkbox__content">
											<svg width="17" height="13" viewBox="0 0 17 13" fill="none" xmlns="http://www.w3.org/2000/svg">
												<path d="M15.0806 0L5.75806 9.20833L1.91935 5.41667L0 7.3125L5.75806 13L17 1.89583L15.0806 0Z" fill="white" />
											</svg>
										</span>

										<p>{$oznakomlenSection.name} <a href="{$SITE_URL}{$oznakomlenSection.url}">{$oznakomlenSection.alias}</a></p>
									</label>
								</div>
								{/if}
								<input type="hidden" name="feedback[subject]"  value="Заявка">
								<button class="btn accent-2 full" type="submit">Подать заявку</button>
							</form>
						</div>

					</div>

				</div>

			</div>

		</div>
	</section>
	{/if}
    {* /Контакты *}

</main>


{include file="footer.tpl"}





