# PHP-HTTP

Утилиты протокола передачи гипертекста (HTTP) для PHP

## Использование

### Response headers

 * Получение заголовка (с необязательным префиксом значения)

   ```php
   \Mnv\Http\ResponseHeader::get('Content-type');
   // or
   \Mnv\Http\ResponseHeader::get('Content-type', 'text/');
   ```

 * Установка заголовка (перезапись других заголовков с тем же именем)

   ```php
   \Mnv\Http\ResponseHeader::set('X-Frame-Options', 'SAMEORIGIN');
   ```

 * Добавление заголовка (сохранение других заголовков с тем же именем)

   ```php
   \Mnv\Http\ResponseHeader::add('X-Frame-Options', 'SAMEORIGIN');
   ```

 * Удаление заголовка (с необязательным префиксом значения)

   ```php
   \Mnv\Http\ResponseHeader::get('X-Powered-By');
   // or
   \Mnv\Http\ResponseHeader::get('X-Powered-By', 'PHP');
   ```

 * Получение и удаление заголовка сразу (с необязательным префиксом значения)

   ```php
   \Mnv\Http\ResponseHeader::take('Set-Cookie');
   // or
   \Mnv\Http\ResponseHeader::take('Set-Cookie', 'mysession=');
   ```
