<form method="post" enctype="multipart/form-data">

	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/managergroups{if !empty($page)}?page={$page}{/if}"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/managergroups" class="breadcrumb-item">{$title|default:""}</a>
    {/capture}

    {capture name="showBy"}
    {/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<!-- Content area -->
	<div class="content">

		<div class="row">
			<div class="col-md-12">
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:tabs:general}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="row">
								<div class="col-md-4">
									<div class="form-group mb-3">
										<label for="groupName" class="form-label {if isset($errors.nameEmpty)}text-danger{/if}">Группа</label>
										<input type="text" class="form-control" autocomplete="off" id="groupName" name="group[groupName]" value="{$group.groupName|default:''}" />
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group mb-3">
										<label class="form-label is-visible {if isset($errors.fileNameEmpty) || isset($errors.fileNameExists) || isset($errors.fileNameCharacters)}text-danger{/if}">Название на латинице</label>
										<input type="text" class="form-control" autocomplete="off" id="fileName" name="group[fileName]" value="{$group.fileName|default:""}" />
									</div>
								</div>
                                {* field status *}
                                {include file="components/fields/select.tpl" col="col-md-4" id="status" title="{general:status}" field="group[status]" array=$statuses selected=$group.status|default:'V' class="form-group mb-3"}
                                {* /field status *}

								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label">Описание</label>
										<textarea rows="3" cols="3" class="form-control" name="group[description]" placeholder="Описание">{$group.description|default:''}</textarea>
									</div>
								</div>
							</div>
						</div>
                        {if isset($group.addedOn) && isset($group.modifiedOn)}
						<div class="card-footer hstack gap-3 justify-content-between">
							<div class="text-muted">
								<ul class="list list-unstyled mb-0 fs-sm">
                                    <li>Пользователей группы</li>
                                    <li>{general:created}</li>
                                    <li>{general:modified}</li>
								</ul>
							</div>
							<div class="hstack gap-1">
								<ul class="list list-unstyled mb-0 fs-sm">
									<li>{$group.countUsers|default:0}</li>
                                    <li>{$group.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$group.addedBy.loginName|default:"{general:unknownUser}"})</li>
                                    <li>{$group.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$group.modifiedBy.loginName|default:"{general:unknownUser}"})</li>
								</ul>
							</div>
						</div>
                        {/if}
					</div>
				</div>
			</div>
            {* права доступа *}
			<div class="col-md-12">
				<div class="alert bg-info text-white alert-styled-left alert-dismissible">
					<span class="font-weight-semibold">Указать привилегии к пунктам меню</span> которые будут отображаться только для этой группы пользователей, с ограничениями доступа к другим пунктам меню.
				</div>
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0 {if isset($errors.privilegesEmpty)}text-danger{/if}">Настроить привилегии для этой группы пользователей</h6>
						<div class="d-inline-flex ms-auto">
							<div class="form-check form-check-inline">
								<input type="checkbox" class="form-check-input form-check-input-info  all_perms" id="all_perms" value="">
								<label class="form-check-label" for="all_perms">Все пункты меню</label>
							</div>
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body flex-column flex-md-row">
							<div class="boxed fn_toggle_wrap">
                                {* права доступа *}
                                {strip}
									<div class="toggle_body_wrap on fn_card">
                                        {foreach $permission as $title => $items}
											<div class="card-body bg-light permission_block mb-2">
												<h6 class="fw-semibold">{$items.name}</h6>
												<div class="permission_boxes row fn_perms_wrap">
                                                    {foreach $items.children as $key => $item}
														<div class="col-xl-2 col-lg-3 col-md-6 mb-2">
															<div class="permission_box">
																<div class="form-check form-check-inline">
																	<input type="checkbox" class="form-check-input form-check-input-info item_perm" id="{$item.fileName}_{$key}" name="privileges[]" value="{$item.fileName}" {if isset($group.privilege) &&  in_array($item.fileName, $group.privilege)}checked{/if}>
																	<label class="form-check-label" for="{$item.fileName}_{$key}">{$item.name|escape}</label>
																</div>
															</div>
														</div>
                                                    {/foreach}
												</div>
											</div>
                                        {/foreach}
									</div>
                                {/strip}
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="col-md-12 text-center">
                {if isset($group.groupId)}<input type="hidden" class="form-control" id="id" name="id" value="{$group.groupId|default:''}">{/if}
                {$smarty.capture.buttons nofilter}
			</div>
		</div>

	</div>
</form>

<script>
    $(document).ready(function () {

        {if isset($errors.nameEmpty)}     new Noty({ text: 'Введите название группы.', type: 'error' }).show(); {/if}
        {if isset($errors.fileNameEmpty)}     new Noty({ text: 'Введите название группы на латинице.', type: 'error' }).show(); {/if}
        {if isset($errors.fileNameExists)}    new Noty({ text: 'Группа с таким названием уже существует', type: 'error' }).show(); {/if}
        {if isset($errors.fileNameCharacters)} new Noty({ text: 'Имя файла может содержать только следующие символы: A-Z a-z, - _', type: 'error' }).show(); {/if}
        {if isset($errors.not_saved)}       new Noty({ text: 'Группа не сохранена', type: 'error' }).show(); {/if}
        {if isset($errors.privilegesEmpty)} new Noty({ text: 'У группы пользователей должна быть хотя бы одна привилегия.', type: 'error' }).show(); {/if}

        {if isset($messages.saved)} new Noty({ text: 'Группа сохранена', type: 'success' }).show(); {/if}
    });

    function deleteSuccess(id) {
        new Noty({ text: 'Группа удалена', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'group');
    }
    function deleteError() {
        new Noty({ text: 'Группа не удалена', type: 'error', timeout: 1500 }).show();
    }

    $(document).on("change", ".all_perms", function () {
        if($(this).is(":checked")) {
            $('.item_perm').each(function () {
                if(!$(this).is(":checked")) {
                    $(this).trigger("click");
                    // console.log($(this).attr('id'))
                }
            });
        } else {
            $('.item_perm').each(function () {
                if($(this).is(":checked")) {
                    $(this).trigger("click");
                    // console.log($(this).attr('id'))
                }
            })
        }
    });
    $(document).on("change", ".item_perm", function () {
        var id = $(this).attr('id');
        console.log(id);
        if ($(this).is(":checked")) {
            $('#parent_'+id).prop('checked', true);
        } else {
            $('#parent_'+id).prop('checked', false);
        }

    });
</script>

