<!-- Inner content -->
<form method="post" id="section" enctype="multipart/form-data">

    {include file="components/group-buttons.tpl" url="{$adminUrl}/sections?{if !empty($page)}page={$page}{/if}{if !empty($parentId)}&parentId={$parentId}{/if}"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/sections" class="breadcrumb-item">{$title|default:""}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}
    {capture name="showBy"}{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

    <div class="content">
        <div class="row"> 
            <div class="col-md-8">
    		    <div class="card border shadow-sm">
        		    <div class="card-header d-flex flex-wrap">
        				<h6 class="mb-0">{general:card:general}</h6>
			            <div class="d-inline-flex ms-auto">
				            <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
			            </div>
        			</div>
			        <div class="collapse show">
	                    <div class="card-body">
	                        <div class="row">
	                            <div class="col-md-6">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible {if isset($errors.error_parent_type) || isset($errors.sectionType)}text-danger{/if}">{sections:sectionType}</label>
	                                    {html_options options=$types selected=$section.type|default:'' name="section[type]" class="form-control select" id="type"}
	                                </div>
	                            </div>
	                            <div class="col-md-6">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible {if isset($errors.error_parent_typeContent) || isset($errors.error_typeContent)}text-danger{/if}">{sections:contentType}</label>
	                                    {html_options options=$typeContents selected=$section.typeContent|default:'articles' name="section[typeContent]" class="form-control select" id="typeContent"}
	                                </div>
	                            </div>
	                            <div class="col-md-12">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible {if isset($errors.parentId)}text-danger{/if}">{sections:general:parent}</label>
	                                    {if isset($parents)}
	                                        {if isset($section.parentId)}
	                                            {html_options options=$parents selected=$section.parentId id="parentId" name="section[parentId]" class="form-control select"}
	                                        {else}
	                                            {html_options options=$parents id="parentId" selected=$parentId|default:'' name="section[parentId]" class="form-control select"}
	                                        {/if}

	                                    {else}
	                                        <label class="form-label">{sections:general:na}</label>
	                                        <input type="hidden" name="section[parentId]" value="0"/>
	                                    {/if}
	                                </div>
	                            </div>
	                            <div class="col-md-6">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible {if isset($errors.name)}text-danger{/if}">{sections:general:name}</label>
	                                    <input type="text" class="form-control" autocomplete="off" id="name" name="section[name]" value="{if isset($section.name)}{$section.name}{/if}" />
	                                </div>
	                            </div>
	                            <div class="col-md-6">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible">{sections:general:alias}</label>
	                                    <input type="text" class="form-control" autocomplete="off" id="alias" name="section[alias]" value="{if isset($section.alias)}{$section.alias nofilter}{/if}"/>
	                                </div>
	                            </div>

	                            <div class="col-md-12">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">{sections:general:filename}</label>
	                                    <input type="text" class="form-control" id="fileName" name="section[fileName]" value="{if isset($section.fileName)}{$section.fileName|escape}{/if}" />
	                                </div>
	                            </div>
	                        </div>
	                    </div>
			        </div>
    		    </div>

	            {* галерея *}
	            <div class="collapse {if isset($section.enableGallery) and $section.enableGallery eq 1}show{/if}" id="gallery-card">
	                <div class="card border shadow-sm">
	                    <div class="card-header d-flex flex-wrap">
				            <h6 class="mb-0">{general:card:imageLibrary}</h6>
				            <div class="d-inline-flex ms-auto">
					            <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				            </div>
	                    </div>

		                <div class="collapse show">

		                    <div class="card-body">
		                        <div class="row gallery gallery-product gallery-sortable mt-2 sortable" id="fileList">
		                            {if isset($section.gallery)}
		                                {foreach item=file from=$section.gallery}
		                                    <figure class="gallery-item gallery-item-images mb-0" id="gallery-item-{$file.imageId}" data-id="{$file.imageId}">
		                                        <div class="move_zone image">
		                                            <img src="{$file.medium}" alt="{if isset($file.title)}{$file.title}{/if}"/>
		                                            <ul class="gallery-item-controls">
		                                                <li><span>{$file.orderBy}</span></li>
		                                                <li>
		                                                    <span class="edit_image" id="edit_image_{$file.imageId}"
		                                                          data-id="{$file.imageId}"
		                                                          data-title="{$file.title}"
		                                                          data-alias="{$file.alias}"
		                                                          data-description="{$file.description}"
		                                                          data-link="{$file.link}"
		                                                          data-position="{$file.position}"
		                                                          onclick="editPictureInfo({$file.imageId}, 'Добавить описание к картинке', 'section');"><i class="ph-note-pencil"></i></span>
		                                                <li>
		                                                    <span onclick="deletePicture({$file.imageId}, 'section');"><i class="ph-trash"></i></span>
		                                                </li>
		                                            </ul>
		                                        </div>
			                                    <div class="meta" id="meta_image_{$file.imageId}">
				                                    <span id="im_title" class="fs-sm fw-normal fw-semibold">{$file.title}</span>
				                                    <span id="im_alias" class="fs-sm fw-normal">{$file.alias}</span>
				                                    <span id="im_description" class="fs-sm fw-normal">{$file.description nofilter}</span>
				                                    <span id="im_link" class="fs-sm fw-normal">{$file.link}</span>
				                                    <span id="im_position" class="badge bg-primary text-white fs-sm fw-light">{$file.position}</span>
			                                    </div>
		                                    </figure>
		                                {/foreach}
		                            {/if}
		                        </div>
		                    </div>

			                <div class="card-footer d-sm-flex justify-content-sm-between align-items-sm-center py-sm-2">
				                <button type="button" class="btn btn-sm btn-primary btn-upload read-more" data-type="gallery" data-path="/" data-action="read_more"><i class="ph-image me-2"></i> {general:uploadFiles} </button>
				                <button type="button" class="btn btn-sm btn-primary btn-sorting collapse"><i class="icon-checkmark3 me-2"></i> {general:apply}</button>
			                </div>

		                </div>

	                </div>
	            </div>
                {* /галерея *}

	            <div class="card border shadow-sm">
                    <div class="card-header d-flex flex-wrap">
	                    <h6 class="mb-0">{general:card:description}</h6>
	                    <div class="d-inline-flex ms-auto">
		                    <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
	                    </div>
    			    </div>
		            <div class="collapse show">
	                    <div class="card-body flex-column flex-md-row m-0 p-0">
		                     <textarea name="section[content]" class="description">{if isset($section.content)}{$section.content}{/if}</textarea>
	                    </div>
		            </div>
    		    </div>
            </div>
    
    
            <div class="col-md-4">
                {* STATUS *}
        		<div class="card border shadow-sm">

			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:card:statusAndVisibility}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
	                    <div class="card-body">
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="section[status]" array=$statuses selected=$section.status|default:'visible'  class="form-group mb-3"}
                            {* /field status *}

		                    <div class="form-group mb-3">
			                    <label class="form-label is-visible">Тип ссылки <br /><i><code class="p-0">если нужно чтоб переходило на <b>стороний сайт</b> или перейти на какую то <b>другую страницу</b>, укажите (Внешняя ссылка) и <b>обязательно прописать ссылку</b></code></i></label>
			                    {html_options options=$urlTypes selected=$section.urlType|default:'' name="section[urlType]" class="form-control select selectUrlType" id="selectUrlType"}
		                    </div>
		                    <div class="form-group mb-3 collapse {if !empty($section.urlType) AND $section.urlType eq 'external'}show{/if}" id="icon-urlType">
			                    <label class="form-label is-visible  {if isset($errors.externalLink)}text-danger{/if}">Ссылка <code>(t.me/@life)</code></label>
			                    <input type="text" class="form-control" id="link" name="section[externalLink]" value="{if isset($section.externalLink)}{$section.externalLink}{/if}"/>
		                    </div>

		                    <div class="form-check form-check-inline mb-2">
			                    <input type="checkbox" class="form-check-input" id="showMainPage" name="section[showMainPage]" value="1" {if isset($section.showMainPage) and $section.showMainPage eq 1}checked{/if}>
			                    <label class="form-check-label" for="showMainPage">Показать как блок на главной странице</label>
		                    </div>
		                    <div class="form-check form-check-inline mb-2">
			                    <input type="checkbox" class="form-check-input" id="topMenu" name="section[topMenu]" value="1" {if isset($section.topMenu) and $section.topMenu eq 1}checked{/if}>
			                    <label class="form-check-label" for="topMenu">{sections:mainMenu}</label>
		                    </div>
		                    <div class="form-check form-check-inline mb-2">
			                    <input type="checkbox" class="form-check-input" id="footerMenu" name="section[footerMenu]" value="1" {if isset($section.footerMenu) and $section.footerMenu eq 1}checked{/if}>
			                    <label class="form-check-label" for="footerMenu">{sections:footerMenu}</label>
		                    </div>
		                    <div class="form-check form-check-inline mb-2">
			                    <input type="checkbox" class="form-check-input" id="enableGallery" name="section[enableGallery]" value="1" {if isset($section.enableGallery) and $section.enableGallery eq 1}checked{/if} data-bs-toggle="collapse" data-bs-target="#gallery-card" aria-expanded="{if isset($section.enableGallery) and $section.enableGallery eq 1}true{else}false{/if}">
			                    <label class="form-check-label" for="enableGallery">{sections:photoGallery}</label>
		                    </div>
		                    <div class="mb-2">
			                    <div class="form-check form-check-inline mb-2">
				                    <input type="checkbox" class="form-check-input" id="enableIcon" name="section[enableIcon]" value="1" {if isset($section.enableIcon) and $section.enableIcon eq 1}checked{/if} data-bs-toggle="collapse" data-bs-target="#icon-enable" aria-expanded="{if isset($section.enableIcon) and $section.enableIcon eq 1}true{else}false{/if}">
				                    <label class="form-check-label" for="enableIcon">{sections:iconSection}</label>
			                    </div>

			                    <div class="form-group mb-3 collapse {if isset($section.enableIcon) and $section.enableIcon eq 1}show{/if}" id="icon-enable">
				                    <label class="form-label is-visible">{sections:icon}</label>
				                    <input type="text" class="form-control" autocomplete="off" id="icon" name="section[icon]" value="{if isset($section.icon)}{$section.icon}{/if}"/>
			                    </div>
		                    </div>
	                    </div>
				        <div class="card-footer hstack gap-3 justify-content-between">
					        <div class="text-muted">
						        <ul class="list list-unstyled mb-0 fs-sm">
                                    {if isset($section.addedOn)}<li>{general:created}</li>{/if}
                                    {if isset($section.modifiedOn)}<li>{general:modified}</li>{/if}
						        </ul>
					        </div>
					        <div class="hstack gap-1">
						        <ul class="list list-unstyled mb-0 fs-sm">
                                    {if isset($section.addedOn)}<li>{$section.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$section.addedBy.loginName|default:"{general:unknownUser}"})</li>{/if}
                                    {if isset($section.modifiedOn)} <li>{$section.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$section.modifiedBy.loginName|default:"{general:unknownUser}"})</li>{/if}
						        </ul>
					        </div>
				        </div>
			        </div>
    			</div>
    			{* IMAGE *}

                {include file="components/image-preview.tpl"
                    image="{if isset($section.image)}{$section.image.original}{/if}"
                    id="{if isset($section.image)}{$section.image.imageId}{/if}"
                    module='section'}

	            {* FILE *}
	            <div class="card border shadow-sm">
		            <div class="card-header d-flex flex-wrap">
			            <h6 class="mb-0">Брошюра (pdf, word)</h6>
			            <div class="d-inline-flex ms-auto">
				            <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
			            </div>
		            </div>
		            <div class="collapse show">
			            <div class="card-body">
				            <div class="form-group" id="pdf_docs">
					            {if isset($section.docs)}
						            {foreach item=file from=$section.docs}
							            <figure class="docs mb-2" id="docs-item-{$file.imageId}">
                                            {if $file.fileFormat eq 'pdf'}
									            <embed src="{$file.original}" width="100%" height="100%" class="mb-2" type="application/pdf"/>
                                            {/if}
								            <div class="input-group">
									            <span class="input-group-text"><img src="/admin/assets/ico/{$file.fileFormat}.svg" width="30"/></span>
									            <input type="text" class="form-control" value="{$file.fileName}" placeholder="" readonly>
									            <button type="button" class="btn btn-danger" onclick="deleteDocs({$file.imageId}, 'section');"><i class="ph-trash"></i></button>
								            </div>
							            </figure>
						            {/foreach}
					            {/if}
				            </div>
			            </div>
			            <div class="card-footer d-sm-flex justify-content-sm-between align-items-sm-center py-sm-2">
				            <button type="button" class="btn btn-sm btn-primary btn-upload btn-docs read-more" data-type="docs" data-path="/" data-action="read_more"><i class="ph-file-doc me-2"></i> {general:uploadFile} </button>
			            </div>
		            </div>
	            </div>

    			{* SEO card-collapsed *}
    			<div class="card border shadow-sm">
				    <div class="card-header d-flex flex-wrap">
					    <h6 class="mb-0">{general:card:seo}</h6>
					    <div class="d-inline-flex ms-auto">
{*						    <button type="button" class="text-body btn btn-outline-primary border-transparent" onclick="auto_keywords();">Сгенерировать ключевые слова</button>*}
						    <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
					    </div>
				    </div>

				    <div class="collapse show">
	                    <div class="card-body flex-column flex-md-row m-0">
		                    <div class="form-group mb-3">
			                    <div class="form-check form-check-inline mb-2">
				                    <input type="checkbox" class="form-check-input" id="sitemap" name="section[sitemap]" value="Y" {if isset($section.sitemap) and $section.sitemap eq 'Y'}checked{/if} aria-expanded="{if isset($section.sitemap) and $section.sitemap eq 'Y'}true{else}false{/if}">
				                    <label class="form-check-label" for="sitemap">Добавить данный раздел в sitemap.xml</label>
			                    </div>
		                    </div>
					        <div class="form-group mb-3">
						        <label class="form-label is-visible">{general:keywords}</label>
						        <textarea name="section[keywords]" id="keywords" class="form-control" rows="4">{$section.keywords|default:''}</textarea>
{*						        <div class="input-group">*}
{*							        <input type="text" class="form-control tokenfield-single" id="keywords" name="section[keywords]" value="{$section.keywords|default:''}">*}
{*						        </div>*}
					        </div>

	                        <div class="form-group mb-3">
	                            <label class="form-label is-visible">{general:description}</label>
	                            <textarea name="section[description]" id="description" class="form-control" rows="4">{$section.description|default:''}</textarea>
	                        </div>
	                    </div>
				    </div>
        		</div>

                {* SETTINGS *}
                <div class="card border shadow-sm card-collapsed">
	                <div class="card-header d-flex flex-wrap">
		                <h6 class="mb-0">{general:card:advanced}</h6>
		                <div class="d-inline-flex ms-auto">
			                <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
		                </div>
	                </div>
	                <div class="collapse">
	                    <div class="card-body">
	                        <fieldset class="mb-3">
		                        <legend class="fs-base fw-bold border-bottom pb-2 mb-3">Применение для данного {general:section}</legend>

		                        <div class="mb-3">
	                                <label class="form-label is-visible">{general:template}</label>
	                                {html_options values=$templates output=$templates selected=$section.templateName|default:'' name="section[templateName]" class="form-control form-control-sm select"}
	                            </div>
                                {* field isCached *}
                                {include file="components/fields/select.tpl" id="isCached" title="{general:caching}" field="section[isCached]" array=$paramCaching selected=$section.isCached|default:0 class="form-group mb-2"}
                                {* /field isCached *}

		                        <div class="mb-3">
			                        <div class="input-group">
				                        <button type="button" class="btn btn-success"><i class="icon-watch2"></i></button>
				                        {html_options options=$cachingTimeOptions  name="section[cacheTime]" selected=$section.cacheTime|default:1 class="form-control form-control-sm select" data-width="1%"}
				                        {html_options options=$cachingPeriodOptions name="section[cachePeriod]" selected=$section.cachePeriod|default:86400 class="form-control form-control-sm select" data-width="1%"}
			                        </div>
		                        </div>

		                        {* field commentsEnabled *}
		                        {include file="components/fields/select.tpl" id="commentsEnabled" title="{general:comments}" field="section[commentsEnabled]" array=$paramComments selected=$section.commentsEnabled|default:0 class="form-group mb-3"}
		                        {* /field commentsEnabled *}
	                        </fieldset>

	                        <fieldset class="form-group mb-3">
	                            <legend class="fs-base fw-bold border-bottom pb-2 mb-3">Применение для подразделов данного раздела</legend>
	                            <div class="mb-3">
	                                <label class="form-label is-visible">{general:template}</label>
	                                {html_options values=$templates output=$templates selected=$section.subTemplateName|default:'' name="section[subTemplateName]" class="form-control form-control-sm select"}
	                            </div>

		                        {* field subIsCached *}
		                        {include file="components/fields/select.tpl" id="subIsCached" title="{general:caching}" field="section[subIsCached]" array=$paramCaching selected=$section.subIsCached|default:0 class="form-group mb-2"}
		                        {* /field subIsCached *}

		                        <div class="mb-3">
			                        <div class="input-group">
				                        <button type="button" class="btn btn-success"><i class="icon-watch2"></i></button>
				                        {html_options options=$cachingTimeOptions name="section[subCacheTime]" selected=$section.subCacheTime|default:1  class="form-control form-control-sm select" data-width="1%"}
				                        {html_options options=$cachingPeriodOptions name="section[subCachePeriod]" selected=$section.subCachePeriod|default:86400  class="form-control form-control-sm select" data-width="1%"}
			                        </div>
	                            </div>

		                        {* field subCommentsEnabled *}
		                        {include file="components/fields/select.tpl" id="subCommentsEnabled" title="{general:comments}" field="section[subCommentsEnabled]" array=$paramComments selected=$section.subCommentsEnabled|default:0 class="form-group mb-3"}
		                        {* /field subCommentsEnabled *}

	                        </fieldset>


	                        <fieldset class="form-group mb-3">
	                            <legend class="fs-base fw-bold border-bottom pb-2 mb-3">Применение для контента данного раздела</legend>
	                            <div class="form-group mb-3">
	                                <label class="form-label is-visible">{general:template}</label>
	                                {html_options values=$templates output=$templates selected=$section.artTemplateName|default:'' name="section[artTemplateName]" class="form-control form-control-sm select"}
	                            </div>

		                        {* field artIsCached *}
		                        {include file="components/fields/select.tpl" id="artIsCached" title="{general:caching}" field="section[artIsCached]" array=$paramCaching selected=$section.artIsCached|default:0 class="form-group mb-2"}
		                        {* /field artIsCached *}

		                        <div class="input-group">
			                        <button type="button" class="btn btn-success"><i class="icon-watch2"></i></button>
			                        {html_options options=$cachingTimeOptions name="section[artCacheTime]" selected=$section.artCacheTime|default:1 class="form-control form-control-sm select" data-width="1%"}
			                        {html_options options=$cachingPeriodOptions name="section[artCachePeriod]" selected=$section.artCachePeriod|default:86400 class="form-control form-control-sm select" data-width="1%"}
		                        </div>

	                        </fieldset>

	                    </div>
	                </div>
                </div>

            </div>

	        <div class="col-md-12 main main_buttons text-center">
                {if isset($section.sectionId)}<input type="hidden" class="form-control" id="id" name="id" value="{$section.sectionId}">{/if}
                {$smarty.capture.buttons nofilter}
	        </div>

        </div>
    </div>
</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>
    $(document).ready(function () {

        {if isset($messages.saved)} new Noty({ text: '{sections:messages:0}', type: 'success' }).show(); {/if}
        {if isset($messages.deleted)} new Noty({ text: '{sections:messages:1}', type: 'success' }).show(); {/if}
        {if isset($messages.sorted)} new Noty({ text: '{sections:messages:2}', type: 'success' }).show();{/if}

        {if isset($errors.not_saved)} new Noty({ text: '{sections:errors:0}', type: 'error' }).show(); {/if}
        {if isset($errors.section_not_found)} new Noty({ text: '{sections:errors:1}', type: 'error' }).show();{/if}
        {if isset($errors.name)} new Noty({ text: '{sections:errors:2}', type: 'error' }).show(); {/if}
        {if isset($errors.fileName)} new Noty({ text: '{sections:errors:3}', type: 'error' }).show(); {/if}
        {if isset($errors.fileNameExists)} new Noty({ text: '{sections:errors:4}', type: 'error' }).show(); {/if}
        {if isset($errors.htaccess)} new Noty({ text: '{sections:errors:5}', type: 'error' }).show(); {/if}
        {if isset($errors.serializations)} new Noty({ text: '{sections:errors:6}', type: 'error' }).show(); {/if}
        {if isset($errors.fileNameProhibited)} new Noty({ text: '{sections:errors:7}', type: 'error' }).show(); {/if}
        {if isset($errors.fileNameCharacters)} new Noty({ text: '{sections:errors:8}', type: 'error' }).show(); {/if}

        {if isset($errors.error_typeContent)} new Noty({ text: '{sections:errors:13}', type: 'error' }).show(); {/if}
        {if isset($errors.error_parent_typeContent)} new Noty({ text: '{sections:errors:15}', type: 'error' }).show(); {/if}
        {if isset($errors.error_parent_type)} new Noty({ text: '{sections:errors:16}', type: 'error' }).show(); {/if}
        {if isset($errors.sectionType)} new Noty({ text: '{sections:errors:13}', type: 'error' }).show(); {/if}
        {if isset($errors.externalLink)} new Noty({ text: 'Укажите ссылку на модальное окно или внешнюю ссылку', type: 'error' }).show(); {/if}


        var type = $('#type :selected').val();
        if (type === 'plain') {
            $('#typeContent').prop("disabled", true);
            $('.pages').hide();
        }

        $('#type').change(function() {
            var typeContent = $(this).val();
            $('#typeContent').prop("disabled", true);
            $('.pages').hide();
            if (typeContent === 'tree') {
                $('.pages').show();
                $('#typeContent').prop("disabled", false);
            }
        });

        // сортировать фотогалею
        $(document).on('click', '.sortable_save_button', function () {
            var ids = new Array();
            $('#fileList figure.gallery-item').each(function () {
                console.log($(this).attr('data-id'))

                ids.push($(this).attr('data-id'));
            })
            $.post( "{$adminUrl}/section?action=sortPictures", { imageIds : ids }, function() {
                $('.sortable_footer_navbar').removeClass('show');
                $("#fileList").load(location.href + " figure.gallery-item");
                new Noty({ text: 'Фотогалерея отсортирована', type: 'success' }).show();
            });
        })

        $(document).on('click', '.sortable_cancel_button', function () {
            $('.sortable_footer_navbar').removeClass('show');
            $("#fileList").load(location.href + " figure.gallery-item");
        })


        $(document).on('click', '#enableIcon', function(){
            if (!$(this).is(':checked'))
                $('#icon').val('');
        });

        $('#selectUrlType').change(function(){
            console.log($('#selectUrlType').val())
            if($('#selectUrlType').val() === 'external') {
	            if (!$("#icon-urlType").hasClass("show"))
                    $('#icon-urlType').addClass("show");
            } else {
                if ($("#icon-urlType").hasClass("show"))
                    $('#icon-urlType').removeClass("show");

            }
        });
    });

    $(function () { function e() { alias_touched || $("#alias").val(a()), keywords_touched || $("#keywords").val(i()), description_touched || $("#description").val(t()), fileName_touched || $("#fileName").val(n()) } function a() { return name = $("#name").val() } function m() { return name = $("#name").val() } function i() { return name = $("#name").val() } function t() { return name = $("#name").val() } function n() { return fileName = $("#name").val(), fileName = fileName.replace(/[\s]+/gi, "{$config.filename_word_separator}"), fileName = l(fileName), fileName = fileName.replace(/[^0-9a-z_\-]+/gi, "").toLowerCase() } function l(e) { for (var a = "А-а-Б-б-В-в-Ґ-ґ-Г-г-Д-д-Е-е-Ё-ё-Є-є-Ж-ж-З-з-И-и-І-і-Ї-ї-Й-й-К-к-Л-л-М-м-Н-н-О-о-П-п-Р-р-С-с-Т-т-У-у-Ф-ф-Х-х-Ц-ц-Ч-ч-Ш-ш-Щ-щ-Ъ-ъ-Ы-ы-Ь-ь-Э-э-Ю-ю-Я-я".split("-"), i = "A-a-B-b-V-v-G-g-G-g-D-d-E-e-E-e-E-e-ZH-zh-Z-z-I-i-I-i-I-i-J-j-K-k-L-l-M-m-N-n-O-o-P-p-R-r-S-s-T-t-U-u-F-f-H-h-TS-ts-CH-ch-SH-sh-SCH-sch-'-'-Y-y-'-'-E-e-YU-yu-YA-ya".split("-"), t = "", n = 0, l = e.length; l > n; n++) {
        var o = e.charAt(n),c = a.indexOf(o);t += c >= 0 ? i[c] : o
    } return t }
        alias_touched = !0,
            keywords_touched = !0,
            description_touched = !0,
            fileName_touched = !0,
        ($("#alias").val() == a() || "" == $("#alias").val()) && (alias_touched = !1),
        ($("#keywords").val() == i() || "" == $("#keywords").val()) && (keywords_touched = !1),
        ($("#description").val() == t() || "" == $("#description").val()) && (description_touched = !1),
        ($("#fileName").val() == n() || "" == $("#fileName").val()) && (fileName_touched = !1),
            $("#alias").change( function () { alias_touched = !0 }),
            $("#keywords").change( function () { keywords_touched = !0 }),
            $("#description").change( function () { description_touched = !0 }),
            $("#fileName").change( function () { fileName_touched = !0 }),
            $("#name").keyup( function () { e() })
    });

</script>


