<!-- Page header -->
{capture name="buttons"}
	<button type="button" class="btn btn-sm btn-primary clear_log"><i class="ph-trash me-2"></i> Очистить журнал</button>
{/capture}
{capture name="breadcrumb"}
	<a href="{$adminUrl}/logs" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url="{$adminUrl}/logs"}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->

<div class="content">
	<div class="row">
		<div class="col-md-12">
			<div class="card border shadow-sm">
				<div class="">
					<table class="table table-togglable table-striped table-hover" id="logs">
						<thead>
						<tr>
							<th data-hide="phone" class="text-center" width="30">Дата</th>
							<th data-hide="phone" class="text-center">Тип события</th>
							<th data-hide="phone" class="text-center">Пользователь</th>
							<th data-toggle="true">Запись</th>
						</tr>
						</thead>
                        {if $datalog}
							<tbody>
                            {foreach from=$datalog item=rLog}
								<tr>
									<td class="text-start text-nowrap">{$rLog.date_log} {if !empty($rLog.user_ip)}{$r->user_ip}{/if}</td>
									<td class="text-center"><span class="badge bg-{if $rLog.type_log eq "error"}danger{elseif $rLog.type_log eq "info"}info{else}primary{/if}">{$rLog.type_log}</span></td>
									<td class="text-center"><span class="badge bg-primary">{if $rLog.userId ne 0}{$rLog.loginName}{else}Гость{/if}</span></td>
									<td class="text-start text-nowrap text-danger">{$rLog.message}</td>

								</tr>
                            {/foreach}
							</tbody>
                        {else}
	                        <tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                        {/if}
					</table>
				</div>

                {include file="module/pagination.tpl" url="{$adminUrl}/logs" params="{$buildQueryString}"}
			</div>
		</div>

	</div>
</div>
<script>

    $(document).on('click', '.clear_log', function () {
        $.post( "{$adminUrl}/logs", { action : "clear" }, function( response ) {
            new Noty({ text: response.message, type: response.type, timeout: 1500 }).show();
            if (response.status == 200) {
                var myTable = document.getElementById("logs");
                for (var a = myTable.rows.length - 1; a > 0; a--) {
                    myTable.deleteRow(a)
                }
            }
        });
    })
</script>





