<form method="post" id="language">

	<!-- Page header -->
{*    {include file="components/group-buttons.tpl" url="{$adminUrl}/langs"}*}
    {capture name="buttons"}
	    <button class="btn btn-sm btn-primary" type="submit" name="action" value="save"><i class="ph-floppy-disk me-2"></i> {general:save}</button>
        {if !isset($multiLang.isDefault)}
		    <a class="btn btn-sm btn-light ms-2" href="{$adminUrl}/langs">{general:cancel}</a>
        {/if}
	    <!-- Page header -->
    {/capture}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/langs" class="breadcrumb-item">{$title}</a>
    {/capture}

    {capture name="showBy"}
    {/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->
    
    
    <!-- Content area -->
    <div class="content">
        <div class="row"> 
            <div class="col-md-8">
    
    		    <div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:card:general}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
	                    <div class="card-body">
	                        <div class="row">
	                            {if !isset($language.languageId)}
					                <div class="col-md-12">
							            <div class="form-group mb-3">
								            <label class="form-label is-visible">{languages:predefinedLanguages}</label>
	                                        {html_options options=$languageOptions selected=$language.codename|default:'' name=languageOptions onChange="languageOptionChange(this)" class="form-control select"}
							            </div>
					                </div>
	                            {/if}
	                            <div class="{if !isset($language.languageId)} col-md-6{else}col-md-12{/if}">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible {if isset($errors.languageName)}text-danger{/if}">{languages:language}</label>
	                                    <input type="text" class="form-control" autocomplete="off" id="languageName" name="language[languageName]" value="{if isset($language.languageName)}{$language.languageName}{/if}" placeholder="{languages:languageDesc}">
	                                </div>

	                                {if !isset($language.languageId)}
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible {if isset($errors.codename) || isset($errors.codenameExists) || isset($errors.codenameCharacters)}text-danger{/if}">{languages:codename}</label>
	                                    <input class="form-control" autocomplete="off" id="codename" type="text" name="language[codename]" value="{if isset($language.codename)}{$language.codename}{/if}" placeholder="{languages:codenameDesc}"/>
	                                </div>
	                                {/if}
	                            </div>

	                            <div class="col-md-6">
	                                {if !isset($action.toMultilangMode)}
	                                    {if !isset($language.languageId)}
	                                    <div class="form-group mb-3">
	                                        <label class="form-label is-visible">{settings:regional:adminLang}</label>
	                                        <script type="text/javascript">
	                                            lang2charset = {ldelim}	{foreach item=charset key=lang from=$languageCharsets name=languageCharsets}"{$lang}":"{$charset}"
	                                            {if !$smarty.foreach.languageCharsets.last},{/if}{/foreach} {rdelim};
	                                        </script>
	                                        {html_options options=$adminLangs name="language[admin_language]" id="adminLanguageOptions" class="form-control select"}
	                                    </div>
	                                    <div class="form-group mb-3">
	                                        <label class="form-label is-visible">{settings:regional:charset}</label>
	                                        {html_options options=$charsetOptions name="language[charset]" id="charsetOptions" class="form-control select"}
	                                    </div>
	                                    {/if}
	                                {/if}
	                            </div>
	                        </div>
	                    </div>
			        </div>
    		    </div>
            </div>

            <div class="col-md-4">
        		<div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:card:statusAndVisibility}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
	                    <div class="card-body">
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="language[status]" array=$statuses selected=$language.status|default:'V'  class="form-group mb-3"}
                            {* /field status *}
	                    </div>
                        {if isset($language.addedOn) && isset($language.modifiedOn)}
				        <div class="card-footer hstack gap-3 justify-content-between">
					        <div class="text-muted">
						        <ul class="list list-unstyled mb-0 fs-sm">
	                                <li>{general:created}</li>
	                                <li>{general:modified}</li>
						        </ul>
					        </div>
					        <div class="hstack gap-1">
						        <ul class="list list-unstyled mb-0 fs-sm">
	                                <li>{$language.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$language.addedBy.loginName|default:"{general:unknownUser}"})</li>
	                                <li>{$language.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$language.modifiedBy.loginName|default:"{general:unknownUser}"})</li>
						        </ul>
					        </div>
				        </div>
				        {/if}
			        </div>
    			</div>
            </div>

	        <div class="col-md-12 text-center">
                {if isset($language.languageId)}<input type="hidden" class="form-control" id="id" name="id" value="{$language.languageId|default:''}">{/if}
                {$smarty.capture.buttons nofilter}
	        </div>

        </div>
    </div>

</form>

<script>
  	
$(document).ready(function () {
    {if isset($errors.not_saved)} new Noty({ text: '{languages:errors:0}', type: 'error', timeout: 1500 }).show(); {/if}
    {if isset($errors.language_not_found)} new Noty({ text: '{languages:errors:1}', type: 'error', timeout: 1500 }).show(); {/if}
    {if isset($errors.languageName)} new Noty({ text: '{languages:errors:2}', type: 'error', timeout: 1500 }).show(); {/if}
    {if isset($errors.codename)} new Noty({ text: '{languages:errors:3}', type: 'error', timeout: 1500 }).show(); {/if}
    {if isset($errors.codenameExists)} new Noty({ text: '{languages:errors:4}', type: 'error', timeout: 1500 }).show(); {/if}
    {if isset($errors.codenameCharacters)} new Noty({ text: '{languages:errors:7}', type: 'error', timeout: 1500 }).show();{/if}
    {if isset($errors.languageNameCharacters)} new Noty({ text: '{languages:errors:9}', type: 'error', timeout: 1500 }).show();{/if}

    {if isset($errors.htaccess)} new Noty({ text: '{languages:errors:5}', type: 'error', timeout: 1500 }).show(); {/if}
    {if isset($errors.serializations)} new Noty({ text: '{languages:errors:6}', type: 'error', timeout: 1500 }).show(); {/if}
    
    {if isset($messages.saved)} new Noty({ text: '{languages:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}
    {if isset($messages.deleted)}
		new Noty({ text: '{languages:messages:1}', type: 'success', timeout: 1500 }).show();

	{/if}
});
function moveUpMessage(){ new Noty({ text: '{sections:messages:3}', type: 'warning', timeout: 1500 }).show(); }
function moveDownMessage(){ new Noty({ text: '{sections:messages:4}', type: 'warning', timeout: 1500 }).show(); }
  
document.getElementById('language').languageName.focus();

{if isset($action.toMultilangMode)}

    var website_language = '{$config.website_language}';
    
    var languageOptions = document.getElementById('languageOptions').options;
    for (i = 0; i < languageOptions.length; i++) {
    	if (languageOptions[i].value == website_language) {
    		languageOptions[i].selected = true;
    		languageOptionChange(languageOptions);
    		break;
    	}
    }

{/if}
</script>
