<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\Users\UserTypes;
use Mnv\Models\Users\UserFactory;
use Mnv\Models\Users\Exceptions\NoUserException;
use Mnv\Models\Users\Exceptions\EmptyUserIdException;
use Mnv\Models\Users\Exceptions\NotUserApproveException;
use Mnv\Models\Users\Exceptions\UserNotDeletedException;
use Mnv\Models\Users\Exceptions\CannotBeRemovedDeveloperException;
use Mnv\Models\Users\Exceptions\CannotBeRemovedAdministratorException;

/**
 * Class SubscribersAdmin
 * @package Mnv\Admin\Controllers
 */
class SubscribersAdmin extends AdminMnv
{

    public function fetch()
    {
        $subscribersUser = UserFactory::subscribersUser();

        /** Заголовок, название подключаемого шаблона */
        $this->smarty->assign('activeItem','subscribers');
        $this->smarty->assign('title', lang('users:title'));

        /** Получаемые параметры $_GET / $_POST */
        $subscribersUser->userId  = (int) $this->request->get('id');

        if ($this->action === 'remove') {
            $result = $subscribersUser->deleteSubscriber()
                ? array('status' => 200, 'message' => lang('users:messages:1'), 'type' => 'success')
                : array('status' => 403, 'message' => lang('users:errors:17'), 'type' => 'error');
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        /* получение всех менеджеров с картинками */
        $users = collect($subscribersUser->all('userId DESC', $this->limit, $this->page))->map(function ($item) {
            $item['registered'] = adjustTime($item['registered'], false, 'd.m.Y');

            return $item;
        })->all();

        /* получение кол-во менеджеров */
        $subscribersUser->total();
        $pages = getPageNums($subscribersUser->total, $this->page, $this->limit, 0, 4, 4, 0);
        $this->smarty->assign('pageNums', $pages);
        $this->smarty->assign('users', $users);
        $this->smarty->assign('page', $this->page);


        /** Права доступа к данному шаблону */
        if ($this->permissions('subscribers')) {
            return $this->smarty->fetch('views/users/subscribers.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }
}




