<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Filesystem\Filesystem;

/**
 * Class LogoAdmin
 * @package Mnv\Admin\Controllers
 */
class LogoAdmin extends AdminMnv
{

    public function fetch()
    {
        $filesystem = new Filesystem();
        $extensions = array('jpeg', 'jpg', 'png', 'gif', 'svg');

        $this->smarty->assign('activeItem','logo');
        $this->smarty->assign('title', lang('logo:logo'));

        $logo = $this->request->get('logo','');
        if ($this->request->hasFile('file')) {
            $downloadableFile = $this->request->files->get('file', '');
        }

        if ($this->action == 'upload') {

            /** удаление старого логотипа */
            if ($fileOld = getLogoFile(SITE_ROOT.'/uploads/')) {
                $filesystem->delete(SITE_ROOT.'/uploads/' . $fileOld[0]);
            }

            if ($downloadableFile->getSize() < ($this->config['max_up_size'] * 1024 * 1024)) {
                if (in_array($downloadableFile->getClientOriginalExtension(), $extensions)) {
                    if ($downloadableFile->move(SITE_ROOT.'/uploads/', 'logo.' . $downloadableFile->getClientOriginalExtension())) {
                        $this->response = array('status' => 200, 'message' => lang('fileManager:messages:1'), 'type' => 'success');
                    } else {
                        $this->response = array('status' => 500, 'message' => lang('fileManager:errors:0'), 'type' => 'error');
                    }
                } else {
                    $this->response = array('status' => 500, 'message' => lang('logo:errors:1'), 'type' => 'error');
                }
            } else {
                $this->response = array('status' => 500, 'message' => lang('fileManager:errors:15'), 'error' => lang('fileManager:errors:15') . ' (MAX UP SIZE)', 'type' => 'error');
            }

            response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();

            exit();

        }
        /** удаление */
        else if ($this->action == 'remove') {

            if ($filesystem->exists(SITE_ROOT.'/uploads/' . $logo['fileName'])) {
                $filesystem->delete(SITE_ROOT.'/uploads/' . $logo['fileName']);
                $this->response = array('status' => 200, 'message' => lang('logo:messages:1'), 'type' => 'success');
            } else {
                $this->response = array('status' => 500, 'message' => 'Логотип не найден', 'type' => 'error');
            }

            response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();
            exit();
        }


        if ($file = getLogoFile(SITE_ROOT.'/uploads/')) {
            $logos['logoName']    = 'logo';
            $logos['fileName']    = $file[0];
            $logos['logoType']    = preg_replace('/^.*\./', '', $file[0]);
        }

        if (!empty($logos)) {
            $this->smarty->assign('logos', $logos);
        }

        if ($this->permissions('logo')) {
            return $this->smarty->fetch('views/logo/logo.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}

  

	


