<!DOCTYPE html>
<html lang="{$config.website_language}">
<head>
	{include file="modules/meta.tpl"}
    {include file="modules/link.tpl"}

</head>

<body>

{fetch_sections assign=headerMenus status="V" topMenu=1 level=1}
<header class="header header_js">
	<div class="flex:col-max">
		<div class="header__inner">
            {logo link=true classLink="header__logo"}
			<nav class="header__nav">
				<ul>
                    {foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
						<li><a href="{if !empty($headerMenu.externalLink)}{$headerMenu.externalLink}{else}{$SITE_URL}#{$headerMenu.fileName}{/if}">{$headerMenu.alias}</a></li>
                    {/foreach}
                                        {assign var=phones value=", "|explode:$config.phone}
                                        {foreach from=$phones item=phone name=phones}
										<li><a href="tel:{$phone|strip_phone}">{$phone|format_phone}</a></li>
                                        {/foreach}
				</ul>
			</nav>

			<div class="header__lang">
				<ul>
					<li>
						<button><img src="{$ASSETS_URL}/images/icons/lang/ru.svg" alt="Ру"> Ру</button>
						<ul>
							<li><a href="{$GLOBAL_URL}/uz/"><img src="{$ASSETS_URL}/images/icons/lang/uz.svg" alt="Uz"> Uz</a></li>
							<li><a href="{$GLOBAL_URL}/en/"><img src="{$ASSETS_URL}/images/icons/lang/en.svg" alt="En"> En</a></li>
						</ul>
					</li>
				</ul>
			</div>

			<button class="burger-btn burger-btn_short menu-call_js">
				<span class="burger-btn__item"></span>
			</button>
		</div>
	</div>

	<div class="header-mob header-mob_js">
		<div class="header-mob__inner">
			<div class="header-mob__head">
                {logo link=true classLink="header-mob__logo"}
				<div class="header-mob__lang">
					<ul>
						<li><span>Ру</span></li>
						<li><a href="{$GLOBAL_URL}/uz/">Uz</a></li>
						<li><a href="{$GLOBAL_URL}/en/">En</a></li>
					</ul>
				</div>
			</div>

			<div class="header-mob__menu">
				<ul>
                    {foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
					<li><a href="{if !empty($headerMenu.externalLink)}{$headerMenu.externalLink}{else}{$SITE_URL}#{$headerMenu.fileName}{/if}">{$headerMenu.alias}</a></li>
					{/foreach}
				</ul>
			</div>

			<div class="header-mob__footer">
				<div class="header-mob__list">
					<ul>
						<li>{$config.address}</li>
						<li><a href="mailto:{$config.email}">{$config.email}</a></li>
                        {assign var=phones value=", "|explode:$config.phone}
                        {foreach from=$phones item=phone name=phones}
							<li><a href="tel:{$phone|strip_phone}">{$phone|format_phone}</a></li>
                        {/foreach}
					</ul>
				</div>
				<div class="social">{include file="modules/socials.tpl"}</div>
			</div>

		</div>
	</div>

</header>

