
<!-- Page header -->
{capture name="buttons"}
{/capture}

{capture name="breadcrumb"}
	<a href="{$adminUrl}/visitor" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url="{$adminUrl}/visitors"}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->

<div class="content">
	<div class="row">
		<div class="col-md-12">
			<div class="card border shadow-sm">
                {include file="views/stats/form/selectors.tpl" action="{$adminUrl}/visitor?visitorId=$visitorId" select=''}
			</div>
		</div>

		<div class="col-md-6">
			<div class="card border shadow-sm">
				<div class="card-header d-flex flex-wrap">
					<h6 class="mb-0">{stats:visitorInfo}</h6>
					<div class="d-inline-flex ms-auto">
						<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
					</div>
				</div>
				<div class="collapse show">
					<table class="table table-xs table-striped table-actions table-hover">
						<tbody>
						<tr>
							<td class="text-right text-nowrap">{stats:visitorId}:</td>
							<td>{$visitorId}</td>
						</tr>
						<tr>
							<td class="text-right text-nowrap">{stats:referer}:</td>
							<td class="text-left">
                                {if isset($visitor.refererUrl)}
									<a href="{$visitor.refererUrl}" target="_blank">
                                        {if isset($visitor.refererWebsite)}
                                            {$visitor.refererWebsite|truncate:50}
                                        {else}
                                            {$visitor.refererUrl|truncate:50}
                                        {/if}
									</a>
                                {else}
                                    {$visitor.referer|truncate:50}
                                {/if}
							</td>
						</tr>
                        {if isset($visitor.searchPhrase)}
							<tr>
								<td class="text-right text-nowrap">{stats:searchQuery}:</td>
								<td class="text-left">{$visitor.searchPhrase|truncate:50}</td>
							</tr>
                        {/if}
						<tr>
							<td class="text-right text-nowrap">{stats:visitorIp}:</td>
							<td class="text-left">{$visitor.visitorIp} (<a href="http://whois.domaintools.com/{$visitor.visitorIp}" target="_blank">{stats:whois}</a>)</td>
						</tr>
						<tr>
							<td class="text-right">{stats:useragent}:</td>
							<td class="text-left" title="{$visitor.userAgent}">{$visitor.userAgent}</td>
						</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>

		<div class="col-md-6">
			<div class="card border shadow-sm">
				<div class="card-header d-flex flex-wrap">
					<h6 class="mb-0">{stats:firstVisit}</h6>
					<div class="d-inline-flex ms-auto">
						<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
					</div>
				</div>
				<div class="collapse show">
					<table class="table table-xs table-striped table-actions table-hover">
						<tbody>
						<tr>
							<td class="text-right text-nowrap">{general:date}:</td>
							<td class="text-nowrap">{$visitor.firstVisitOn nofilter}</td>
						</tr>
						<tr>
							<td class="text-right text-nowrap" width="120">{stats:type}:</td>
							<td class="text-left">

                                {if $visitor.firstVisit.typeId eq 6}
									<span class="code{if isset($visitor.firstVisit.errorCode)}{$visitor.firstVisit.errorCode}{/if}">{stats:error} {if isset($visitor.firstVisit.errorCode)}{$visitor.firstVisit.errorCode}{/if}</span>
                                {elseif $visitor.firstVisit.typeName}
                                    {$visitor.firstVisit.typeName nofilter}
                                {/if}
							</td>
						</tr>
						<tr>
							<td class="text-right text-nowrap">{stats:page}:</td>
							<td class="text-left">
                                {if isset($visitor.firstVisit.typeId) and $visitor.firstVisit.typeId eq 1}
									<a href="{$SITE_URL}/" target="_blank">{stats:homePage}</a>
                                {elseif $visitor.firstVisit.typeId eq 2 && isset($visitor.firstVisit.name)}
									<a href="{$visitor.firstVisit.url}" target="_blank">{$visitor.firstVisit.name|truncate:50}</a>
                                {elseif $visitor.firstVisit.typeId eq 3 && isset($visitor.firstVisit.title)}
									<a href="{$visitor.firstVisit.url}" target="_blank">{$visitor.firstVisit.title|truncate:50} </a>
                                {elseif $visitor.firstVisit.typeId eq 4}
									<a href="{$SITE_URL}/search.php?query={$visitor.firstVisit.searchQuery|escape:'url'}&page={$visitor.firstVisit.searchPage}" target="_blank">{$visitor.firstVisit.searchQuery|truncate:50}</a>
                                {elseif $visitor.firstVisit.typeId eq 6}
									<a href="{if isset($visitor.firstVisit.requestUri)} {$visitor.firstVisit.requestUri} {/if}" target="_blank">
                                        {if isset($visitor.firstVisit.requestUri)} {$visitor.firstVisit.requestUri|truncate:50} {/if}
									</a>
                                    {if isset($visitor.firstVisit.refererUrl)}
	                                    (<a href="{$visitor.firstVisit.refererUrl}" target="_blank">{"{stats:referer}"|lower}</a>)
                                    {/if}
                                {elseif $visitor.firstVisit.typeId eq 7}
                                    {if !isset($visitor.firstVisit.section)}
										<a href="{$SITE_URL}/rss.xml" target="_blank">{stats:genRss}</a>
                                    {elseif $visitor.firstVisit.section}
										<a href="{$visitor.firstVisit.section.path}/rss.xml" target="_blank">{$visitor.firstVisit.section.name|truncate:35}</a>
                                    {else}
                                        {stats:unknown}
                                    {/if}
                                {elseif $visitor.firstVisit.typeId eq 8}
									<a href="{$SITE_URL}/sitemap.{$config.file_extension}" target="_blank">{stats:genSitemap}</a>
                                {elseif $visitor.firstVisit.typeId eq 9}
									<a href="{$SITE_URL}/sitemap.xml" target="_blank">{stats:xmlSitemap}</a>
                                {elseif $visitor.firstVisit.typeId eq 11}
									<a href="{$visitor.firstVisit.url}" target="_blank">{$visitor.firstVisit.alias|default:$visitor.firstVisit.title|truncate:45}</a>
                                {elseif $visitor.firstVisit.typeId eq 12}
									<a href="{$visitor.firstVisit.url}" target="_blank">{$visitor.firstVisit.alias|default:$visitor.firstVisit.title|truncate:45}</a>
                                {elseif $visitor.firstVisit.typeId eq 13}
									<a href="{$visitor.firstVisit.url}" target="_blank">{$visitor.firstVisit.alias|default:$visitor.firstVisit.title|truncate:45}</a>
                                {else}
                                    {stats:unknown}
                                {/if}
							</td>
						</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>

		<div class="col-md-12">
			<div class="card border shadow-sm">
				<div class="card-header d-flex flex-wrap">
					<h6 class="mb-0">{stats:visit}</h6>
					<div class="d-inline-flex ms-auto">
						<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
					</div>
				</div>
				<div class="collapse show">
					<table class="table table-xs table-striped table-actions table-hover">
						<thead>
						<tr>
							<th class="text-center">{general:date}</th>
							<th class="text-center">{stats:type}</th>
							<th class="text-left">{stats:visit}</th>
						</tr>
						</thead>
                        {if isset($visits) && !empty($visits)}
							<tbody>
                            {foreach item=visit from=$visits name=visits}
								<tr id="visit-{$visit.visitId}" {if isset($visit.isHidden)}style="display:none"{/if}>
									<td class="text-left text-nowrap">{if isset($visit.visitDate)}{$visit.visitDate}{/if}</td>
									<td class="text-nowrap">
                                        {if isset($visit.typeId) && $visit.typeId eq 6}
											<span class="code{if isset($visit.errorCode)}{$visit.errorCode}{/if}">{stats:error} {if isset($visit.errorCode)}{$visit.errorCode}{/if}</span>
                                        {else}
                                            {if isset($visit.typeName)}{$visit.typeName nofilter}{/if}
                                        {/if}
									</td>
									<td class="text-left" width="100%">
                                        {if isset($visit.typeId) and $visit.typeId eq 1}
											<a href="{$SITE_URL}/" target="_blank">{stats:homePage}</a>
                                        {elseif isset($visit.typeId) && $visit.typeId eq 2 && isset($visit.name)}
											<a href="{$visit.url}" target="_blank">{$visit.name|truncate:60}</a>
                                        {elseif isset($visit.typeId) &&  $visit.typeId eq 3 && isset($visit.title)}
											<a href="{$visit.url}" target="_blank">{$visit.title|truncate:60}</a>
                                        {elseif isset($visit.typeId) && $visit.typeId eq 4}
											<a href="{$SITE_URL}/search.php?query={$visit.searchQuery|escape:'url'}&page={$visit.searchPage}" target="_blank">{$visit.searchQuery|truncate:60}</a>
                                        {elseif isset($visit.typeId) && $visit.typeId eq 6}
											<a href=" {if isset($visit.requestUri)}{$visit.requestUri}{/if}" target="_blank">{if isset($visit.requestUri)}{$visit.requestUri|truncate:60}{/if}</a>
                                            {if isset($visit.refererUrl)} (<a href="{$visit.refererUrl}" target="_blank">{"{stats:referer}"}</a>) {/if}
                                        {elseif isset($visit.typeId) && $visit.typeId eq 7}
                                            {if !isset($visit.section)}
												<a href="{$SITE_URL}/rss.xml" target="_blank">{stats:genRss}</a>
                                            {elseif $visit.section}
												<a href="{$visit.section.path}/rss.xml" target="_blank">{$visit.section.name|truncate:60}</a>
                                            {else}
                                                {stats:unknown}
                                            {/if}
                                        {elseif isset($visit.typeId) && $visit.typeId eq 8}
											<a href="{$SITE_URL}/sitemap.{$config.file_extension}" target="_blank">{stats:genSitemap}</a>
                                        {elseif isset($visit.typeId) && $visit.typeId eq 9}
											<a href="{$SITE_URL}/sitemap.xml" target="_blank">{stats:xmlSitemap}</a>
                                        {elseif isset($visit.typeId) && $visit.typeId eq 10}
											<a href="{$visit.url}" target="_blank">{$visit.alias|default:$visit.title|truncate:60}</a>
                                        {elseif isset($visit.typeId) && $visit.typeId eq 11}
											<a href="{$visit.url}" target="_blank">{$visit.alias|default:$visit.title|truncate:60}</a>
                                        {elseif isset($visit.typeId) && $visit.typeId eq 12}
											<a href="{$visit.url}" target="_blank">{$visit.alias|default:$visit.title|truncate:60}</a>
                                        {elseif isset($visit.typeId) && $visit.typeId eq 13}
											<a href="{$visit.url}" target="_blank">{$visit.alias|default:$visit.title|truncate:60}</a>
                                        {else}
                                            {stats:unknown}
                                        {/if}
									</td>
								</tr>
                            {/foreach}
							</tbody>
                        {else}
							<tbody><tr><td colspan="3" class="text-center">- {general:none} -</td></tr></tbody>
                        {/if}

					</table>
				</div>
                {include file="module/pagination.tpl" url="{$adminUrl}/visitor" params="&visitorId={$visitorId}{if isset($filterTypeId)}&filterTypeId={$filterTypeId}{/if}"}
			</div>
		</div>
	</div>
</div>
<!-- /content area -->
