<!DOCTYPE html>
<html lang="{$config.website_language}">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<title>{if isset($title)}{$title} - {/if}{productName}</title>

	<link rel="apple-touch-icon" sizes="57x57" href="/admin/assets/favicon/apple-icon-57x57.png">
	<link rel="apple-touch-icon" sizes="60x60" href="/admin/assets/favicon/apple-icon-60x60.png">
	<link rel="apple-touch-icon" sizes="72x72" href="/admin/assets/favicon/apple-icon-72x72.png">
	<link rel="apple-touch-icon" sizes="76x76" href="/admin/assets/favicon/apple-icon-76x76.png">
	<link rel="apple-touch-icon" sizes="114x114" href="/admin/assets/favicon/apple-icon-114x114.png">
	<link rel="apple-touch-icon" sizes="120x120" href="/admin/assets/favicon/apple-icon-120x120.png">
	<link rel="apple-touch-icon" sizes="144x144" href="/admin/assets/favicon/apple-icon-144x144.png">
	<link rel="apple-touch-icon" sizes="152x152" href="/admin/assets/favicon/apple-icon-152x152.png">
	<link rel="apple-touch-icon" sizes="180x180" href="/admin/assets/favicon/apple-icon-180x180.png">
	<link rel="icon" type="image/png" sizes="192x192"  href="/admin/assets/favicon/android-icon-192x192.png">
	<link rel="icon" type="image/png" sizes="32x32" href="/admin/assets/favicon/favicon-32x32.png">
	<link rel="icon" type="image/png" sizes="96x96" href="/admin/assets/favicon/favicon-96x96.png">
	<link rel="icon" type="image/png" sizes="16x16" href="/admin/assets/favicon/favicon-16x16.png">
	<link rel="manifest" href="/admin/assets/favicon/manifest.json">
	<meta name="msapplication-TileColor" content="#ffffff">
	<meta name="msapplication-TileImage" content="/admin/assets/favicon/ms-icon-144x144.png">
	<meta name="theme-color" content="#ffffff">


	<!-- Global stylesheets -->
	<link href="/admin/assets/fonts/inter/inter.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/icons/phosphor/styles.min.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/all.min.css" id="stylesheet" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/add.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/gallery.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/media.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/animate.min.css" id="stylesheet" rel="stylesheet" type="text/css">
	<link href="/admin/assets/icons/icomoon/styles.min.css" rel="stylesheet" type="text/css">
	<!-- /global stylesheets -->

	<!-- Core JS files -->
	<script src="/admin/assets/js/configurator.js"></script>
	<script src="/admin/assets/js/bootstrap/bootstrap.bundle.min.js"></script>
	<script src="/admin/assets/js/jquery/jquery.min.js"></script>
	<script src="/admin/assets/js/jquery/jquery-ui.min.js"></script>
	<script src="/admin/assets/js/vendor/forms/selects/bootstrap_multiselect.js"></script>
	<!-- /core JS files -->

	<!-- Theme JS files -->
	<script src="/admin/assets/js/vendor/ui/moment/moment.min.js"></script>
	<script src="/admin/assets/js/vendor/ui/dragula.min.js"></script>
	<script src="/admin/assets/js/vendor/media/glightbox.min.js"></script>
	<script src="/admin/assets/js/vendor/uploaders/fileinput/fileinput.min.js"></script>
	<script src="/admin/assets/js/vendor/uploaders/dropzone.min.js"></script>
	<script src="/admin/assets/js/vendor/forms/selects/select2.min.js"></script>
	<script src="/admin/assets/js/vendor/forms/tags/tokenfield.min.js"></script>
	<script src="/admin/assets/js/vendor/forms/validation/validate.min.js"></script>
	<script src="/admin/assets/js/vendor/forms/validation/localization/messages_{$config.website_language}.js"></script>
	<script src="/admin/assets/js/vendor/forms/inputs/passy.js"></script>
	<script src="/admin/assets/js/vendor/pickers/daterangepicker.js"></script>
	<script src="/admin/assets/js/vendor/pickers/datepicker.min.js"></script>
	<script src="/admin/assets/js/vendor/pickers/color/spectrum.js"></script>
	<script src="/admin/assets/js/vendor/sliders/nouislider.min.js"></script>
	<script src="/admin/assets/js/vendor/tables/datatables/datatables.min.js"></script>
	<script src="/admin/assets/js/vendor/clipboard/clipboard.min.js"></script>
	<script src="/admin/assets/js/vendor/loaders/blockui.min.js"></script>
	<script src="/admin/assets/js/vendor/notifications/bootbox.min.js"></script>
	<script src="/admin/assets/js/vendor/notifications/noty.min.js"></script>
	<script src="/admin/assets/js/vendor/ui/prism.min.js"></script>
	<script src="/admin/assets/js/app.js"></script>



	<!-- /theme JS files -->
	<script>
        var lang = [];
        {foreach key=langKey item=langVal from=$jsLang}
            lang['{$langKey}'] = '{$langVal}';
        {/foreach}
	</script>
	{script src='/admin/assets/js/script.js'}
	{include file="init/date-time-pickers.tpl"}



</head>


<body class="{if isset($smarty.cookies.mini_sidebar) AND $smarty.cookies.mini_sidebar eq true}sidebar-xs{/if}">

{if !empty($alert)}{$alert}{/if}

<!-- Main navbar -->
<div class="navbar navbar-dark navbar-expand-lg navbar-static border-bottom border-bottom-white border-opacity-10">
	<div class="container-fluid">
		<div class="d-flex d-lg-none me-2">
			<button type="button" class="navbar-toggler sidebar-mobile-main-toggle rounded-pill">
				<i class="ph-list"></i>
			</button>
		</div>

		<div class="navbar-brand flex-1 flex-lg-0">
			<a href="{$adminUrl}/main" class="d-inline-flex align-items-center">
				<img src="/admin/assets/images/logo_light.png" alt="{productName}">
{*				<img src="/admin/assets/images/logo_light.png" class="d-none d-sm-inline-block h-16px ms-3" alt="{productName}">*}
			</a>
		</div>

		<ul class="nav flex-row">
{*			<li class="nav-item d-lg-none">*}
{*				<a href="#navbar_search" class="navbar-nav-link navbar-nav-link-icon rounded-pill" data-bs-toggle="collapse">*}
{*					<i class="ph-magnifying-glass"></i>*}
{*				</a>*}
{*			</li>*}

			<li class="nav-item nav-item-dropdown-lg dropdown">
				<a href="{$SITE_URL}" class="navbar-nav-link navbar-nav-link-icon rounded-pill" target="_blank">
					<i class="ph-browser me-2"></i>Перейти на сайт
				</a>
			</li>

			{if $config.comments_enabled && !empty($comments)}
			<li class="nav-item nav-item-dropdown-lg dropdown ms-lg-2">
				<a href="javascript:void('');" class="navbar-nav-link navbar-nav-link-icon rounded-pill" data-bs-toggle="dropdown" data-bs-auto-close="outside">
					<i class="ph-chats"></i>
                    {if $totalPendingComments > 0}
					<span class="badge bg-yellow text-black position-absolute top-0 end-0 translate-middle-top zindex-1 rounded-pill mt-1 me-1">{$totalPendingComments}</span>
					{/if}
				</a>

				<div class="dropdown-menu wmin-lg-400 p-0">
					<div class="d-flex align-items-center p-3">
						<h6 class="mb-0">{comments:news}</h6>
						<div class="ms-auto">
{*							<a href="#search_messages" class="collapsed text-body ms-2" data-bs-toggle="collapse">*}
{*								<i class="ph-magnifying-glass"></i>*}
{*							</a>*}
						</div>
					</div>

					{* нужно реализовать поиск*}
					<div class="collapse" id="search_messages">
						<div class="px-3 mb-2">
							<div class="form-control-feedback form-control-feedback-start">
								<input type="text" class="form-control" placeholder="Search messages">
								<div class="form-control-feedback-icon">
									<i class="ph-magnifying-glass"></i>
								</div>
							</div>
						</div>
					</div>

					<div class="dropdown-menu-scrollable pb-2">
                        {foreach item=pendingComment from=$pendingComments name=pendingComments}
						<a href="{$adminUrl}/comment?action=edit&id={$pendingComment.commentId}" class="dropdown-item align-items-start text-wrap py-2">
							<div class="flex-1">
								<span class="fw-semibold"> {$pendingComment.authorName|truncate:20}</span>
								<span class="text-muted float-end fs-sm">{$pendingComment.addedOn}</span>
								<div class="text-muted">{$pendingComment.content|strip_tags|truncate:100}</div>
							</div>
						</a>
						{/foreach}
					</div>

					<div class="d-flex border-top py-2 px-3">
						<a href="{$adminUrl}/comments" class="text-body ms-auto">Смотреть все<i class="ph-arrow-circle-right ms-1"></i></a>
					</div>
				</div>
			</li>
			{/if}
		</ul>

		<div class="navbar-collapse justify-content-center flex-lg-1 order-2 order-lg-1 collapse" id="navbar_search">
			{*<div class="navbar-search flex-fill position-relative mt-2 mt-lg-0 mx-lg-3">
				<div class="form-control-feedback form-control-feedback-start flex-grow-1" data-color-theme="dark">
					<input type="text" class="form-control bg-transparent rounded-pill" placeholder="Поиск..." name="query" value="{$query}" data-bs-toggle="dropdown">
					<div class="form-control-feedback-icon"><i class="ph-magnifying-glass"></i></div>

					<div class="dropdown-menu w-100" data-color-theme="light">
						<button type="button" class="dropdown-item">
							<div class="text-center w-32px me-3"><i class="ph-magnifying-glass"></i></div>
							<span>Искать <span class="fw-bold">"в"</span> везде</span>
						</button>

						<div class="dropdown-divider"></div>

						<div class="dropdown-menu-scrollable-lg">
							<div class="dropdown-header"> Клиенты <a href="/admin/clients" class="float-end">Показать все <i class="ph-arrow-circle-right ms-1"></i></a></div>

							<div class="dropdown-item cursor-pointer">
								<div class="d-flex flex-column flex-grow-1">
									<div class="fw-semibold">Christ<mark>in</mark>e Johnson</div>
									<span class="fs-sm text-muted">c.johnson@awesomecorp.com</span>
								</div>

								<div class="d-inline-flex">
									<a href="#" class="text-body ms-2">
										<i class="ph-user-circle"></i>
									</a>
								</div>
							</div>

							<div class="dropdown-item cursor-pointer">
								<div class="d-flex flex-column flex-grow-1">
									<div class="fw-semibold">Cl<mark>in</mark>ton Sparks</div>
									<span class="fs-sm text-muted">c.sparks@awesomecorp.com</span>
								</div>

								<div class="d-inline-flex">
									<a href="#" class="text-body ms-2">
										<i class="ph-user-circle"></i>
									</a>
								</div>
							</div>

							<div class="dropdown-divider"></div>

							<div class="dropdown-header"> Проекты <a href="/admin/projects" class="float-end">Показать все <i class="ph-arrow-circle-right ms-1"></i></a></div>

							<div class="dropdown-item cursor-pointer">
								<div class="d-flex flex-column flex-grow-1">
									<div class="fw-semibold">Adobe <mark>In</mark>c.</div>
									<span class="fs-sm text-muted">Enterprise license</span>
								</div>

								<div class="d-inline-flex">
									<a href="#" class="text-body ms-2">
										<i class="ph-briefcase"></i>
									</a>
								</div>
							</div>

							<div class="dropdown-item cursor-pointer">
								<div class="d-flex flex-column flex-grow-1">
									<div class="fw-semibold">Holiday-<mark>In</mark>n</div>
									<span class="fs-sm text-muted">On-premise license</span>
								</div>

								<div class="d-inline-flex">
									<a href="#" class="text-body ms-2">
										<i class="ph-briefcase"></i>
									</a>
								</div>
							</div>

							<div class="dropdown-item cursor-pointer">
								<div class="d-flex flex-column flex-grow-1">
									<div class="fw-semibold"><mark>IN</mark>G Group</div>
									<span class="fs-sm text-muted">Perpetual license</span>
								</div>

								<div class="d-inline-flex">
									<a href="#" class="text-body ms-2">
										<i class="ph-briefcase"></i>
									</a>
								</div>
							</div>
						</div>
					</div>
				</div>

				<a href="#" class="navbar-nav-link align-items-center justify-content-center w-40px h-32px rounded-pill position-absolute end-0 top-50 translate-middle-y p-0 me-1" data-bs-toggle="dropdown" data-bs-auto-close="outside">
					<i class="ph-faders-horizontal"></i>
				</a>

				<div class="dropdown-menu w-100 p-3">
					<div class="d-flex align-items-center mb-3">
						<h6 class="mb-0">Параметры поиска</h6>
						<a href="#" class="text-body rounded-pill ms-auto"><i class="ph-clock-counter-clockwise"></i></a>
					</div>

					<div class="mb-3">
						<label class="d-block form-label">Категория</label>
						<label class="form-check form-check-inline">
							<input type="checkbox" class="form-check-input" name="projects" checked>
							<span class="form-check-label">Проекты</span>
						</label>
						<label class="form-check form-check-inline">
							<input type="checkbox" class="form-check-input" name="clients">
							<span class="form-check-label">Клиенты</span>
						</label>
					</div>

					<div class="mb-3">
						<label class="form-label">Дополнение</label>
						<div class="input-group">
							<select class="form-select w-auto flex-grow-0">
								<option value="1" selected>has</option>
								<option value="2">has not</option>
							</select>
							<input type="text" class="form-control" placeholder="Enter the word(s)">
						</div>
					</div>

					<div class="mb-3">
						<label class="form-label">Статус</label>
						<div class="input-group">
							<select class="form-select w-auto flex-grow-0">
								<option value="1" selected>is</option>
								<option value="2">is not</option>
							</select>
							<select class="form-select">
								<option value="1" selected>Active</option>
								<option value="2">Inactive</option>
								<option value="3">New</option>
								<option value="4">Expired</option>
								<option value="5">Pending</option>
							</select>
						</div>
					</div>

					<div class="d-flex">
						<button type="button" class="btn btn-light">Reset</button>

						<div class="ms-auto">
							<button type="button" class="btn btn-light">Cancel</button>
							<button type="button" class="btn btn-primary ms-2">Apply</button>
						</div>
					</div>
				</div>
			</div>*}
		</div>

		<ul class="nav flex-row justify-content-end order-1 order-lg-2">
            {if $LANGUAGES|@count > 1}
				<li class="nav-item dropdown ms-xl-1">
                    {foreach item=navLang from=$LANGUAGES}{if ($SITE_LANG eq $navLang.codename) || (!$SITE_LANG && $navLang.isDefault)}
						<a href="" class="navbar-nav-link rounded dropdown-toggle" data-bs-toggle="dropdown">
							<img src="{$GLOBAL_URL}/admin/assets/lang/{$navLang.codename}.svg" class="w-24px h-24px rounded-pill me-2" alt="{$navLang.codename}">
                            {$navLang.languageTransName|default:$navLang.languageName}
						</a>
                    {/if}{/foreach}
					<div class="dropdown-menu dropdown-menu-end" data-bs-popper="static">
                        {foreach item=navLang from=$LANGUAGES}
							<a href="{$GLOBAL_URL}/admin/{if !$navLang.isDefault}{$navLang.codename}/{/if}{$smarty.const.REQUESTED_FILE}" class="dropdown-item
    						{if ($SITE_LANG eq $navLang.codename) || (!$SITE_LANG && $navLang.isDefault)}active{/if}">
								<img src="{$GLOBAL_URL}/admin/assets/lang/{$navLang.codename}.svg" class="w-24px h-24px rounded-pill me-2" alt="{$navLang.codename}">
                                {$navLang.languageTransName|default:$navLang->languageName}
							</a>
                        {/foreach}
					</div>
				</li>
            {/if}

{*			<li class="nav-item ms-lg-2">*}
{*				<a href="javascript:void('');" class="navbar-nav-link navbar-nav-link-icon rounded-pill" data-bs-toggle="offcanvas" data-bs-target="#notifications">*}
{*					<i class="ph-bell"></i>*}
{*					<span class="badge bg-yellow text-black position-absolute top-0 end-0 translate-middle-top zindex-1 rounded-pill mt-1 me-1">2</span>*}
{*				</a>*}
{*			</li>*}
            {if isset($adminManager)}
			<li class="nav-item nav-item-dropdown-lg dropdown ms-lg-2">
				<a href="javascript:void('');" class="navbar-nav-link align-items-center rounded-pill p-1" data-bs-toggle="dropdown">
					<div class="status-indicator-container">
						<img src="{if isset($adminManager.image)}{$adminManager.image.large}{else}/admin/assets/img/no_images.jpg{/if}" class="w-32px h-32px rounded-pill" alt="{$adminManager.fullName}">
						<span class="status-indicator bg-success"></span>
					</div>
					<span class="d-none d-lg-inline-block mx-lg-2">{$adminManager.fullName}</span>
				</a>

				<div class="dropdown-menu dropdown-menu-end">
					<div class="dropdown-header fs-sm ">Сайт</div>
					<a href="{$SITE_URL}" class="dropdown-item" target="_blank"><i class="ph-browser me-2"></i>Перейти на сайт</a>
					<div class="dropdown-divider"></div>
					<div class="dropdown-header fs-sm">Аккаунт</div>
					<a class="dropdown-item" href="{if $adminManager.userType eq Mnv\Models\Users\UserTypes::DEVELOPER}{$adminUrl}/developer?action=edit&id={$adminManager.userId}{else}{$adminUrl}/manager?action=edit&id={$adminManager.userId}{/if}"><i class="ph-gear me-2"></i>Ваш профиль</a>
					<a class="dropdown-item" href="{if $adminManager.userType eq Mnv\Models\Users\UserTypes::DEVELOPER}{$adminUrl}/developer?action=add{else}{$adminUrl}/manager?action=add{/if}"><i class="ph-user-circle me-2"></i>Добавить аккаунт</a>
{*					<div class="dropdown-divider"></div>*}
					<a class="dropdown-item" href="{$adminUrl}/auth?action=logout"><i class="ph-sign-out me-2"></i> Выйти</a>
				</div>
			</li>
            {/if}
		</ul>
	</div>
</div>
<!-- /main navbar -->


<!-- Page content -->
<div class="page-content">

	<!-- Main sidebar -->
	<div class="sidebar sidebar-dark sidebar-main sidebar-expand-lg">

		<!-- Sidebar content -->
		<div class="sidebar-content">

			<!-- Sidebar header -->
			<div class="sidebar-section">
				<div class="sidebar-section-body d-flex justify-content-center">
					<h5 class="sidebar-resize-hide flex-grow-1 my-auto">Navigation</h5>

					<div>
						<button type="button" class="btn btn-flat-white btn-icon btn-sm rounded-pill border-transparent sidebar-control sidebar-main-resize d-none d-lg-inline-flex">
							<i class="ph-arrows-left-right"></i>
						</button>

						<button type="button" class="btn btn-flat-white btn-icon btn-sm rounded-pill border-transparent sidebar-mobile-main-toggle d-lg-none">
							<i class="ph-x"></i>
						</button>
					</div>
				</div>
			</div>
			<!-- /sidebar header -->


			<!-- Main navigation -->
			<div class="sidebar-section">
				<ul class="nav nav-sidebar" data-nav-type="accordion">
					<li class="nav-item-header pt-0">
						<div class="text-uppercase fs-sm lh-sm opacity-50 sidebar-resize-hide">Main</div>
						<i class="ph-dots-three sidebar-resize-show"></i>
					</li>
					<li class="nav-item">
						<a href="{$adminUrl}/main" class="nav-link {if isset($activeItem) && ($activeItem eq 'main')}active{/if}"><i class="ph-house"></i><span data-i18n="menu.dashboard">Dashboard</span></a>
					</li>

					<!-- Main -->
                    {if isset($adminManager)}
                        {foreach from=$menu item=itemMenu}{if isset($itemMenu.activeItems)}
							<li class="nav-item nav-item-submenu {foreach from=$itemMenu.activeItems item=active}{if isset($activeItem) && ($activeItem eq $active)}nav-item-expanded nav-item-open{/if}{/foreach}">
								<a href="javascript:void('');" class="nav-link">
									<i class="{$itemMenu.icon}"></i>
									<span data-i18n="menu.{$itemMenu.name}"> {$itemMenu.name}</span>
								</a>
								<ul class="nav-group-sub collapse {foreach from=$itemMenu.activeItems item=active}{if isset($activeItem) && ($activeItem eq $active)}show{/if}{/foreach}"
								    data-submenu-title="{$itemMenu.name}">
                                    {foreach from=$itemMenu.children item=subItemMenu}
										<li class="nav-item">
											<a class="nav-link {if isset($activeItem) && ($activeItem eq $subItemMenu.fileName)}active{/if}"
											   href="{$adminUrl}/{$subItemMenu.fileName}">
                                                {if isset($subItemMenu.icon)}<i class="{$subItemMenu.icon}"></i>{/if}
												{$subItemMenu.name}
											</a>
										</li>
                                    {/foreach}
								</ul>
							</li>
                        {/if} {/foreach}
                    {/if}
{*                    {if $adminManager.userType eq Mnv\Models\Users\UserTypes::DEVELOPER}*}
{*					<li class="nav-item">*}
{*						<a href="{$adminUrl}/collection" class="nav-link {if isset($activeItem) && ($activeItem eq 'collection')}active{/if}"><i class="ph-coffee"></i><span>Коллекция</span></a>*}
{*					</li>*}
{*                    {/if}*}
					<li class="nav-item">
						<a href="{$adminUrl}/about" class="nav-link {if isset($activeItem) && ($activeItem eq 'about')}active{/if}"><i class="ph-coffee"></i><span data-i18n="menu.about">О проекте</span></a>
					</li>
				</ul>
			</div>
			<!-- /main navigation -->

		</div>
		<!-- /sidebar content -->

	</div>
	<!-- /main sidebar -->


	<!-- Main content -->
	<div class="content-wrapper">

		<!-- Inner content -->
		<div class="content-inner">

            {if $content}

                {$content nofilter}

            {else}
					<!-- Page header -->
					<div class="page-header page-header-light">
						<div class="page-header-content header-elements-md-inline">
							<div class="page-title d-flex">
								<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{if isset($title)}{$title}{/if}</span></h4>
								<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
							</div>

							<div class="header-elements d-none">
								<div class="d-flex justify-content-center">
									<a href="{$adminUrl}/overview" class="btn btn-link btn-float font-size-sm font-weight-semibold text-default legitRipple"><i class="icon-bars-alt text-pink-300"></i><span>Статистика</span></a>
								</div>
							</div>
						</div>

						<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
						</div>
					</div>
					<!-- /page header -->
					<!-- Content area -->
					<div class="content">
						<div class="row">
							<div class="col-lg-12 col-md-12 col-sm-12 mt-1">
								<div class="boxed boxed_warning">
									<div class="heading_box">
										<h1>Такого модуля не существует</h1>
									</div>
								</div>
							</div>
						</div>
					</div>
            {/if}




		</div>
		<!-- /inner content -->

		<!-- Footer -->
		{* сортировка перемещением в таблице *}
		<div class="navbar navbar-sm navbar-footer border-top sortable_footer_navbar collapse">
			<div class="col-12">
				<div class="d-flex justify-content-center">
					<button class="btn btn-sm btn-primary sortable_save_button me-2" type="button">{general:apply}</button>
					<button class="btn btn-sm btn-light sortable_cancel_button" type="button">{general:cancel}</button>
				</div>
			</div>
		</div>
        {* /сортировка перемещением в таблице *}

		{* действия с контентом при выборе checkboxes *}
		<div class="navbar navbar-sm navbar-footer border-top footer_navbar collapse">
			<div class="col-12">
				<ul class="nav nav-pills justify-content-center">
					<li class="nav-item">
						<div class="input-group">
							<select class="form-control select content_select_action" name="group_action" data-width="250">
								<option value="0">Выбрать действие...</option>
								<option value="status"> Изменить статус</option>
								<option value="remove">Удалить выбранное</option>
							</select>
							<button class="btn btn-sm btn-primary px-3 content_save_button" type="button">Применить</button>
						</div>
					</li>
				</ul>
			</div>
		</div>
        {* действия с контентом при выборе checkboxes *}


		<!-- /footer -->

{*		<div class="navbar navbar-sm navbar-footer border-top">*}
{*			<div class="container-fluid">*}
{*				<span>&copy; 2001 - {$smarty.now|date_format:"%Y"}. MNV by <a href="https://www.life-style.uz/" target="_blank">Life Style</a></span>*}

{*				<ul class="nav">*}
{*					<li class="nav-item" style="padding-top: 3px;">*}
{*						<a class="text-left">*}
{*							<i class="icon-meter-fast"></i>&nbsp; Использовано памяти : {$debug_memory} Мб ({$debug_memusage} Мб макс)<br>*}
{*							<i class="icon-history"></i>&nbsp; Время работы скрипта: {$debug_timer} мс*}
{*						</a>*}
{*					</li>*}
{*				</ul>*}
{*			</div>*}
{*		</div>*}

	</div>
	<!-- /main content -->

</div>
<!-- /page content -->


<!-- Notifications -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="notifications">
	<div class="offcanvas-header py-0">
		<h5 class="offcanvas-title py-3">Activity</h5>
		<button type="button" class="btn btn-light btn-sm btn-icon border-transparent rounded-pill" data-bs-dismiss="offcanvas">
			<i class="ph-x"></i>
		</button>
	</div>

	<div class="offcanvas-body p-0">
		<div class="bg-light fw-medium py-2 px-3">New notifications</div>
		<div class="p-3">
			<div class="d-flex align-items-start mb-3">
				<a href="#" class="status-indicator-container me-3">
{*					<img src="../../../assets/images/demo/users/face1.jpg" class="w-40px h-40px rounded-pill" alt="">*}
					<span class="status-indicator bg-success"></span>
				</a>
				<div class="flex-fill">
					<a href="#" class="fw-semibold">James</a> has completed the task <a href="#">Submit documents</a> from <a href="#">Onboarding</a> list

					<div class="bg-light rounded p-2 my-2">
						<label class="form-check ms-1">
							<input type="checkbox" class="form-check-input" checked disabled>
							<del class="form-check-label">Submit personal documents</del>
						</label>
					</div>

					<div class="fs-sm text-muted mt-1">2 hours ago</div>
				</div>
			</div>

			<div class="d-flex align-items-start mb-3">
{*				<a href="#" class="status-indicator-container me-3">*}
{*					<img src="../../../assets/images/demo/users/face3.jpg" class="w-40px h-40px rounded-pill" alt="">*}
{*					<span class="status-indicator bg-warning"></span>*}
{*				</a>*}
				<div class="flex-fill">
					<a href="#" class="fw-semibold">Margo</a> has added 4 users to <span class="fw-semibold">Customer enablement</span> channel

					<div class="d-flex my-2">
{*						<a href="#" class="status-indicator-container me-1">*}
{*							<img src="../../../assets/images/demo/users/face10.jpg" class="w-32px h-32px rounded-pill" alt="">*}
{*							<span class="status-indicator bg-danger"></span>*}
{*						</a>*}
{*						<a href="#" class="status-indicator-container me-1">*}
{*							<img src="../../../assets/images/demo/users/face11.jpg" class="w-32px h-32px rounded-pill" alt="">*}
{*							<span class="status-indicator bg-success"></span>*}
{*						</a>*}
{*						<a href="#" class="status-indicator-container me-1">*}
{*							<img src="../../../assets/images/demo/users/face12.jpg" class="w-32px h-32px rounded-pill" alt="">*}
{*							<span class="status-indicator bg-success"></span>*}
{*						</a>*}
{*						<a href="#" class="status-indicator-container me-1">*}
{*							<img src="../../../assets/images/demo/users/face13.jpg" class="w-32px h-32px rounded-pill" alt="">*}
{*							<span class="status-indicator bg-success"></span>*}
{*						</a>*}
						<button type="button" class="btn btn-light btn-icon d-inline-flex align-items-center justify-content-center w-32px h-32px rounded-pill p-0">
							<i class="ph-plus ph-sm"></i>
						</button>
					</div>

					<div class="fs-sm text-muted mt-1">3 hours ago</div>
				</div>
			</div>

			<div class="d-flex align-items-start">
				<div class="me-3">
					<div class="bg-warning bg-opacity-10 text-warning rounded-pill">
						<i class="ph-warning p-2"></i>
					</div>
				</div>
				<div class="flex-1">
					Subscription <a href="#">#466573</a> from 10.12.2021 has been cancelled. Refund case <a href="#">#4492</a> created
					<div class="fs-sm text-muted mt-1">4 hours ago</div>
				</div>
			</div>
		</div>

		<div class="bg-light fw-medium py-2 px-3">Older notifications</div>
		<div class="p-3">
			<div class="d-flex align-items-start mb-3">
				<a href="#" class="status-indicator-container me-3">
{*					<img src="../../../assets/images/demo/users/face25.jpg" class="w-40px h-40px rounded-pill" alt="">*}
					<span class="status-indicator bg-success"></span>
				</a>
				<div class="flex-fill">
					<a href="#" class="fw-semibold">Nick</a> requested your feedback and approval in support request <a href="#">#458</a>

					<div class="my-2">
						<a href="#" class="btn btn-success btn-sm me-1">
							<i class="ph-checks ph-sm me-1"></i>
							Approve
						</a>
						<a href="#" class="btn btn-light btn-sm">
							Review
						</a>
					</div>

					<div class="fs-sm text-muted mt-1">3 days ago</div>
				</div>
			</div>

			<div class="d-flex align-items-start mb-3">
				<a href="#" class="status-indicator-container me-3">
{*					<img src="../../../assets/images/demo/users/face24.jpg" class="w-40px h-40px rounded-pill" alt="">*}
					<span class="status-indicator bg-grey"></span>
				</a>
				<div class="flex-fill">
					<a href="#" class="fw-semibold">Mike</a> added 1 new file(s) to <a href="#">Product management</a> project

					<div class="bg-light rounded p-2 my-2">
						<div class="d-flex align-items-center">
							<div class="me-2">
{*								<img src="../../../assets/images/icons/pdf.svg" width="34" height="34" alt="">*}
							</div>
							<div class="flex-fill">
								new_contract.pdf
								<div class="fs-sm text-muted">112KB</div>
							</div>
							<div class="ms-2">
								<button type="button" class="btn btn-flat-dark text-body btn-icon btn-sm border-transparent rounded-pill">
									<i class="ph-arrow-down"></i>
								</button>
							</div>
						</div>
					</div>

					<div class="fs-sm text-muted mt-1">1 day ago</div>
				</div>
			</div>

			<div class="d-flex align-items-start mb-3">
				<div class="me-3">
					<div class="bg-success bg-opacity-10 text-success rounded-pill">
						<i class="ph-calendar-plus p-2"></i>
					</div>
				</div>
				<div class="flex-fill">
					All hands meeting will take place coming Thursday at 13:45.

					<div class="my-2">
						<a href="#" class="btn btn-primary btn-sm">
							<i class="ph-calendar-plus ph-sm me-1"></i>
							Add to calendar
						</a>
					</div>

					<div class="fs-sm text-muted mt-1">2 days ago</div>
				</div>
			</div>

			<div class="d-flex align-items-start mb-3">
				<a href="#" class="status-indicator-container me-3">
{*					<img src="../../../assets/images/demo/users/face4.jpg" class="w-40px h-40px rounded-pill" alt="">*}
					<span class="status-indicator bg-danger"></span>
				</a>
				<div class="flex-fill">
					<a href="#" class="fw-semibold">Christine</a> commented on your community <a href="#">post</a> from 10.12.2021

					<div class="fs-sm text-muted mt-1">2 days ago</div>
				</div>
			</div>

			<div class="d-flex align-items-start mb-3">
				<div class="me-3">
					<div class="bg-primary bg-opacity-10 text-primary rounded-pill">
						<i class="ph-users-four p-2"></i>
					</div>
				</div>
				<div class="flex-fill">
					<span class="fw-semibold">HR department</span> requested you to complete internal survey by Friday

					<div class="fs-sm text-muted mt-1">3 days ago</div>
				</div>
			</div>

			<div class="text-center">
				<div class="spinner-border" role="status">
					<span class="visually-hidden">Loading...</span>
				</div>
			</div>
		</div>
	</div>
</div>
<!-- /notifications -->


<!-- Demo config -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="theme_config">
	<div class="position-absolute top-50 end-100 visible">
		<button type="button" class="btn btn-primary btn-icon translate-middle-y rounded-end-0" data-bs-toggle="offcanvas" data-bs-target="#theme_config">
			<i class="ph-gear"></i>
		</button>
	</div>

	<div class="offcanvas-header border-bottom py-0">
		<h5 class="offcanvas-title py-3">Настройки темы</h5>
		<button type="button" class="btn btn-light btn-sm btn-icon border-transparent rounded-pill" data-bs-dismiss="offcanvas">
			<i class="ph-x"></i>
		</button>
	</div>

	<div class="offcanvas-body">
		<div class="fw-semibold mb-2">Color mode</div>
		<div class="list-group mb-3">
			<label class="list-group-item list-group-item-action form-check border-width-1 rounded mb-2">
				<div class="d-flex flex-fill my-1">
					<div class="form-check-label d-flex me-2">
						<i class="ph-sun ph-lg me-3"></i>
						<div>
							<span class="fw-bold">Light theme</span>
							<div class="fs-sm text-muted">Set light theme or reset to default</div>
						</div>
					</div>
					<input type="radio" class="form-check-input cursor-pointer ms-auto" name="main-theme" value="light" checked>
				</div>
			</label>

			<label class="list-group-item list-group-item-action form-check border-width-1 rounded mb-2">
				<div class="d-flex flex-fill my-1">
					<div class="form-check-label d-flex me-2">
						<i class="ph-moon ph-lg me-3"></i>
						<div>
							<span class="fw-bold">Dark theme</span>
							<div class="fs-sm text-muted">Switch to dark theme</div>
						</div>
					</div>
					<input type="radio" class="form-check-input cursor-pointer ms-auto" name="main-theme" value="dark">
				</div>
			</label>

			<label class="list-group-item list-group-item-action form-check border-width-1 rounded mb-0">
				<div class="d-flex flex-fill my-1">
					<div class="form-check-label d-flex me-2">
						<i class="ph-translate ph-lg me-3"></i>
						<div>
							<span class="fw-bold">Auto theme</span>
							<div class="fs-sm text-muted">Set theme based on system mode</div>
						</div>
					</div>
					<input type="radio" class="form-check-input cursor-pointer ms-auto" name="main-theme" value="auto">
				</div>
			</label>
		</div>


	</div>

	<div class="border-top text-center py-2 px-3">
		<ul class="nav">
			<li class="nav-item text-start">
				<span class="fs-sm">
					<i class="icon-meter-fast"></i>&nbsp; Использовано памяти : {$debug_memory} Мб ({$debug_memusage} Мб макс)<br>
					<i class="icon-history"></i>&nbsp; Время работы скрипта: {$debug_timer} мс
				</span>
			</li>
		</ul>
		<span>&copy; 2001 - {$smarty.now|date_format:"%Y"}. MNV by <a href="https://www.life-style.uz/" target="_blank">Life Style</a></span>
	</div>
</div>
<!-- /demo config -->



<!-- настройки таблицы -->
{* <div class="offcanvas offcanvas-end offcanvas-size-lg" tabindex="-1" id="setting_table">
	<div class="offcanvas-header bg-light py-0">
		<h5 class="offcanvas-title py-3">Настройка списка таблицы</h5>
		<button type="button" class="btn btn-light btn-sm btn-icon close_client border-transparent rounded-pill" data-bs-dismiss="offcanvas">
			<i class="ph-x"></i>
		</button>
	</div>

	<div class="offcanvas-body p-3">
        {if isset($all_columns) && !empty($all_columns)}
		<legend class="fs-base fw-bold border-bottom pb-2 mb-3">Колонки таблицы.</legend>
		<div class="row mb-3">
			<div class="col-md-6">
				{foreach from=$all_columns item=all_column name=columns}
				<label class="form-check mb-2">
					<input type="checkbox" class="form-check-input form-check-input-success table_column" value="{$all_column.id}" {if in_array($all_column.id, $selected_columns)}checked=""{/if}>
					<span class="form-check-label">{$all_column.content}</span>
				</label>
				{if $smarty.foreach.columns.iteration % 2 == 0}
			</div>
			<div class="col-md-6">
				{/if}
				{/foreach}
			</div>
		</div>
        {/if}

			<legend class="fs-base fw-bold border-bottom pb-2 mb-3">Параметры по умолчанию.</legend>
			<div class="row mb-3">
				<label class="col-lg-12 col-form-label text-lg-end">Упорядочить по полю:</label>
				<div class="col-lg-12">
					<div class="input-group">
						{if isset($all_columns) && !empty($all_columns)}
						<select class="form-control select order_field" data-width="150">
                            {foreach from=$all_columns item=all_column name=columns}
	                            <option value="{$all_column.id}" {if isset($order_field) && $order_field eq $all_column.id}selected{/if}>{$all_column.content}</option>
	                        {/foreach}
						</select>
						{/if}
						{if isset($order_direction)}
						<select class="form-control select order_direction" data-width="160">
							<option value="desc" {if $order_direction|lower eq 'desc'}selected{/if}>По убыванию</option>
							<option value="asc" {if $order_direction|lower eq 'asc'}selected{/if}>По возрастанию</option>
						</select>
                        {/if}
					</div>
				</div>
				<label class="col-lg-12 col-form-label text-lg-end">Выбранное поле: <span class="fw-semibold">{$order_field}</span></label>

			</div>
			<div class="row mb-3">
				<label class="col-lg-6 col-form-label text-lg-end">Записей на странице:</label>
				<div class="col-lg-6">
					<select class="form-control select" name="nav_page_size">
						<option value="10">10</option>
						<option value="20" selected="">20</option>
						<option value="50">50</option>
						<option value="100">100</option>
						<option value="200">200</option>
						<option value="500">500</option>
					</select>
				</div>
			</div>
	</div>
	<div class="d-flex border-top text-lg-end py-2 px-3">
		<button type="button" class="btn btn-sm btn-link close_setting_table" data-bs-dismiss="offcanvas">Отменить</button>
		<button type="button" class="btn btn-outline-primary save_setting_table">Сохранить</button>
	</div>
</div>
*}

<script>

    /* Call an ajax entity update */
    $(document).on("click", ".ajax_action", function () {
        ajax_action($(this));
    });


    if ($(".ajax_action")) {
        /* Функция аяксового обновления полей
        * state - состояние объекта (включен/выключен)
        * id - id обновляемой сущности
        * module - типо сущности
        * action - обновляемое поле (поле в БД)
        * класс "ajax_block" у елемента - означает массовое обновление;
        * если нужно:
        * 1) добавить класс "ajax_block" к блоку в котором хотите обновить несколько полей,
        * 2) добавить класс "ajax_element" к елементам, в блоке("ajax_block"), которые хотите обновить
        * .fn_ajax_element: аттрибут "name" - поле БД; val() - значение.
        * */
        function ajax_action($this) {
            var value, module, action, id;
            // value = $this.hasClass("active_class") ? 0:1;
            id = parseInt($this.attr('data-id'));
            module = $this.attr("data-module");
            action = $this.attr("data-action");

            console.log(action);
            $.post("{$adminUrl}/"+module, { action: action, id: id }, function(response) {
               if (response.data === true) {
                   new Noty({ text: '{general:restatus}', type: 'success' }).show();
                   if (action === 'status') {
                       $this.closest("tr").toggleClass('table-warning');
                       if (response.status === 'V') {
                            $this.html('<i class="ph-eye me-2"></i> {general:status}');
                            $('#status-'+id).text('{general:statuses:V}');
                       } else {
	                       $this.html('<i class="ph-eye-slash me-2"></i> {general:status}');
	                       $('#status-'+id).text('{general:statuses:H}');
                       }
                    }
               } else {
                    new Noty({ text: '{general:erestatus}', type: 'error'}).show();
               }
           });
        }
    }

    function auto_keywords() {
        tinyMCE.triggerSave();
        var txt = document.getElementsByClassName('description')[0].value;
        $.post("{$adminUrl}/handlers/keywords.php", { content: txt }, function(data) {
            console.log(data.keywords);
            $('#keywords').tokenfield('setTokens', data.keywords);
        });
        return false;
    }

</script>
</body>
</html>
