<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\Logs;

/**
 * Class LogsAdmin
 * @package Mnv\Admin\Controllers
 */
class LogsAdmin extends AdminMnv
{

    public function fetch()
    {
        $log = new Logs();

        $this->smarty->assign('activeItem','logs');
        $this->smarty->assign('title', 'Журнал событий');

        if ($this->action == 'clear') {
            $result = $log->remove()
                ? array('status' => 200, 'message' => 'Журнал очищен', 'type' => 'success')
                : array('status' => 403, 'message' => 'Ошибка при очищение журнала', 'type' => 'error');
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        $logs =  collect($log->all($this->limit, $this->page))->map(function ($item) {
            $item['date_log'] = langDate(adjustTime($item['date_log'], false, 'd.m.Y H:i'));

            return $item;
        })->all();

        $log->total();
        $pages = getPageNums($log->total, $this->page, $this->limit, 0, 4, 4, 0);

        $this->smarty->assign('totalLogs', $log->total);
        $this->smarty->assign('pageNums', $pages);
		$this->smarty->assign("datalog", $logs);

        if ($this->permissions('logs')) {
            return $this->smarty->fetch('views/logs/logs.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }

}

