<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\Feedbacks;

/**
 * Class FeedbackAdmin
 * @package Mnv\Admin\Controllers
 */
class FeedbackAdmin extends AdminMnv
{

    public function fetch()
    {

        $feedback = new Feedbacks($this->request);

        $this->smarty->assign('activeItem','feedbacks');
        $this->smarty->assign('title', 'Центр сообщений');
        $this->smarty->assign('statuses', array_slice(lang('comments:statuses'), 1));

        if ($this->action = 'read') {
            $feedback->edit()->gettingInfoAboutUsers();

        } else if ($this->action = 'save') {
            $feedback->prepare($feedback->data, $this->manager['userId']);
        }


//        print_r($feedbacks->data);

        $this->smarty->assign('mail', $feedback->data);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('feedbacks')) {
            return $this->smarty->fetch('views/feedbacks/feedback.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }
}